/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.entity;

import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.enums.TipoComprobante;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="series")
public class Serie {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipos_comprobante", nullable=false, columnDefinition="ENUM('factura','boleta','nota_credito','nota_debito')")
    private TipoComprobante tiposComprobante;
    @Column(name="serie", columnDefinition="CHAR(4)", nullable=false, unique=true)
    private String serie;
    @Column(name="ultimo_correlativo", nullable=false)
    private Integer ultimoCorrelativo = 0;
    @Column(nullable=false)
    private Boolean activo = Boolean.TRUE;
    @Column(name="es_predeterminada", nullable=false)
    private Boolean esPredeterminada = Boolean.FALSE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
        if (this.esPredeterminada == null) {
            this.esPredeterminada = Boolean.FALSE;
        }
        if (this.ultimoCorrelativo == null) {
            this.ultimoCorrelativo = 0;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Serie() {
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public TipoComprobante getTiposComprobante() {
        return this.tiposComprobante;
    }

    @Generated
    public String getSerie() {
        return this.serie;
    }

    @Generated
    public Integer getUltimoCorrelativo() {
        return this.ultimoCorrelativo;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public Boolean getEsPredeterminada() {
        return this.esPredeterminada;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setTiposComprobante(TipoComprobante tiposComprobante) {
        this.tiposComprobante = tiposComprobante;
    }

    @Generated
    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Generated
    public void setUltimoCorrelativo(Integer ultimoCorrelativo) {
        this.ultimoCorrelativo = ultimoCorrelativo;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setEsPredeterminada(Boolean esPredeterminada) {
        this.esPredeterminada = esPredeterminada;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Serie)) {
            return false;
        }
        Serie other = (Serie)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$ultimoCorrelativo = this.getUltimoCorrelativo();
        Integer other$ultimoCorrelativo = other.getUltimoCorrelativo();
        if (this$ultimoCorrelativo == null ? other$ultimoCorrelativo != null : !((Object)this$ultimoCorrelativo).equals(other$ultimoCorrelativo)) {
            return false;
        }
        Boolean this$activo = this.getActivo();
        Boolean other$activo = other.getActivo();
        if (this$activo == null ? other$activo != null : !((Object)this$activo).equals(other$activo)) {
            return false;
        }
        Boolean this$esPredeterminada = this.getEsPredeterminada();
        Boolean other$esPredeterminada = other.getEsPredeterminada();
        if (this$esPredeterminada == null ? other$esPredeterminada != null : !((Object)this$esPredeterminada).equals(other$esPredeterminada)) {
            return false;
        }
        TipoComprobante this$tiposComprobante = this.getTiposComprobante();
        TipoComprobante other$tiposComprobante = other.getTiposComprobante();
        if (this$tiposComprobante == null ? other$tiposComprobante != null : !this$tiposComprobante.equals(other$tiposComprobante)) {
            return false;
        }
        String this$serie = this.getSerie();
        String other$serie = other.getSerie();
        if (this$serie == null ? other$serie != null : !this$serie.equals(other$serie)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        return !(this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Serie;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $ultimoCorrelativo = this.getUltimoCorrelativo();
        result = result * 59 + ($ultimoCorrelativo == null ? 43 : ((Object)$ultimoCorrelativo).hashCode());
        Boolean $activo = this.getActivo();
        result = result * 59 + ($activo == null ? 43 : ((Object)$activo).hashCode());
        Boolean $esPredeterminada = this.getEsPredeterminada();
        result = result * 59 + ($esPredeterminada == null ? 43 : ((Object)$esPredeterminada).hashCode());
        TipoComprobante $tiposComprobante = this.getTiposComprobante();
        result = result * 59 + ($tiposComprobante == null ? 43 : $tiposComprobante.hashCode());
        String $serie = this.getSerie();
        result = result * 59 + ($serie == null ? 43 : $serie.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Serie(id=" + this.getId() + ", tiposComprobante=" + String.valueOf(this.getTiposComprobante()) + ", serie=" + this.getSerie() + ", ultimoCorrelativo=" + this.getUltimoCorrelativo() + ", activo=" + this.getActivo() + ", esPredeterminada=" + this.getEsPredeterminada() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ")";
    }
}

