/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.controller;

import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.SerieCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.SerieResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.SerieUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.facturacion.service.ISerieService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/facturacion/series"})
@Validated
public class SerieController {
    private final ISerieService serieService;

    @GetMapping
    public ResponseEntity<List<SerieResponse>> listar() {
        return ResponseEntity.ok((Object)this.serieService.listar());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<SerieResponse> obtener(@PathVariable Integer id) {
        return ResponseEntity.ok((Object)this.serieService.obtener(id));
    }

    @PostMapping
    public ResponseEntity<SerieResponse> crear(@Valid @RequestBody SerieCreateRequest request) {
        SerieResponse response = this.serieService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<SerieResponse> actualizar(@PathVariable Integer id, @Valid @RequestBody SerieUpdateRequest request) {
        return ResponseEntity.ok((Object)this.serieService.actualizar(id, request));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Integer id) {
        this.serieService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public SerieController(ISerieService serieService) {
        this.serieService = serieService;
    }
}

