/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.controller;

import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.MetodoPagoRequest;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.MetodoPagoResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.service.IMetodoPagoService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/facturacion/metodos-pago"})
@Validated
public class MetodoPagoController {
    private final IMetodoPagoService metodoPagoService;

    @GetMapping
    public ResponseEntity<List<MetodoPagoResponse>> listar() {
        return ResponseEntity.ok((Object)this.metodoPagoService.listar());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<MetodoPagoResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.metodoPagoService.obtener(id));
    }

    @PostMapping
    public ResponseEntity<MetodoPagoResponse> crear(@Valid @RequestBody MetodoPagoRequest request) {
        return new ResponseEntity((Object)this.metodoPagoService.crear(request), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<MetodoPagoResponse> actualizar(@PathVariable Long id, @Valid @RequestBody MetodoPagoRequest request) {
        return ResponseEntity.ok((Object)this.metodoPagoService.actualizar(id, request));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long id) {
        this.metodoPagoService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public MetodoPagoController(IMetodoPagoService metodoPagoService) {
        this.metodoPagoService = metodoPagoService;
    }
}

