/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.shared.suscripciones.service;

import com.dulcecontrol.bakery.features.shared.suscripciones.model.PlanLimites;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.Plan;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.Suscripcion;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.enums.EstadoSuscripcion;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.repository.SuscripcionRepository;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlanLimitesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanLimitesService.class);
    private static final List<EstadoSuscripcion> ESTADOS_VIGENTES = List.of(EstadoSuscripcion.ACTIVA, EstadoSuscripcion.EN_PRUEBA);
    private final SuscripcionRepository suscripcionRepository;
    private final ObjectMapper objectMapper;

    @Transactional(readOnly=true)
    public PlanLimites obtenerLimitesVigentes(Long tiendaId) {
        if (tiendaId == null) {
            return PlanLimites.sinRestricciones();
        }
        List suscripciones = this.suscripcionRepository.findByTiendaIdAndEstadoInOrderByFechaFinDesc(tiendaId, (Collection)ESTADOS_VIGENTES);
        Suscripcion vigente = suscripciones.stream().findFirst().orElse(null);
        if (vigente == null) {
            return PlanLimites.sinRestricciones();
        }
        return this.extraerLimites(vigente.getPlan());
    }

    private PlanLimites extraerLimites(Plan plan) {
        if (plan == null) {
            return PlanLimites.sinRestricciones();
        }
        String limitesJson = plan.getLimitesJson();
        if (limitesJson == null || limitesJson.isBlank()) {
            return PlanLimites.sinRestricciones();
        }
        try {
            JsonNode raiz = this.objectMapper.readTree(limitesJson);
            Integer maxUsuarios = this.leerEntero(raiz, "usuarios");
            Integer maxSedes = this.leerEntero(raiz, "sedes");
            return new PlanLimites(maxUsuarios, maxSedes);
        }
        catch (JsonProcessingException ex) {
            log.warn("No se pudieron parsear los l\u00edmites del plan {}", (Object)plan.getCodigo(), (Object)ex);
            return PlanLimites.sinRestricciones();
        }
    }

    private Integer leerEntero(JsonNode raiz, String campo) {
        if (raiz == null || !raiz.has(campo)) {
            return null;
        }
        JsonNode nodo = raiz.get(campo);
        if (!nodo.isNumber()) {
            return null;
        }
        int valor = nodo.asInt();
        return valor > 0 ? Integer.valueOf(valor) : null;
    }

    @Generated
    public PlanLimitesService(SuscripcionRepository suscripcionRepository, ObjectMapper objectMapper) {
        this.suscripcionRepository = suscripcionRepository;
        this.objectMapper = objectMapper;
    }
}

