/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.PersonalizacionItemCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PersonalizacionItemResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PersonalizacionItemUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.DetallePedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.PersonalizacionItemPedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.DetallePedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.PersonalizacionItemPedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.IPersonalizacionItemPedidoAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonalizacionItemPedidoAdminService
implements IPersonalizacionItemPedidoAdminService {
    private final PersonalizacionItemPedidoRepository personalizacionRepository;
    private final DetallePedidoRepository detallePedidoRepository;
    private final VentasTenantValidator tenantValidator;

    @Transactional(readOnly=true)
    public PersonalizacionItemResponse obtener(Long tiendaId, Long pedidoId, Long detallePedidoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        this.obtenerDetalle(pedidoId, detallePedidoId);
        PersonalizacionItemPedido personalizacion = (PersonalizacionItemPedido)this.personalizacionRepository.findByDetallePedidoId(detallePedidoId).orElseThrow(() -> new ResourceNotFoundException("Personalizaci\u00f3n no encontrada para el detalle"));
        return this.toResponse(personalizacion);
    }

    @Transactional
    public PersonalizacionItemResponse crear(Long tiendaId, Long pedidoId, Long detallePedidoId, PersonalizacionItemCreateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        this.obtenerDetalle(pedidoId, detallePedidoId);
        if (this.personalizacionRepository.findByDetallePedidoId(detallePedidoId).isPresent()) {
            throw new BadRequestException("El detalle ya cuenta con una personalizaci\u00f3n registrada");
        }
        PersonalizacionItemPedido personalizacion = new PersonalizacionItemPedido();
        personalizacion.setDetallePedidoId(detallePedidoId);
        personalizacion.setDescripcionSolicitud(request.descripcionSolicitud());
        personalizacion.setTextoDedicatoria(request.textoDedicatoria());
        personalizacion.setImagenesReferencia(this.cloneLista(request.imagenesReferencia()));
        personalizacion.setSaborMasa(request.saborMasa());
        personalizacion.setSaborRelleno(request.saborRelleno());
        personalizacion.setTematica(request.tematica());
        personalizacion.setFechaLimiteProduccion(request.fechaLimiteProduccion());
        personalizacion.setCostoExtraPersonalizacionCentimos(request.costoExtraPersonalizacionCentimos());
        PersonalizacionItemPedido guardada = (PersonalizacionItemPedido)this.personalizacionRepository.save((Object)personalizacion);
        return this.toResponse(guardada);
    }

    @Transactional
    public PersonalizacionItemResponse actualizar(Long tiendaId, Long pedidoId, Long detallePedidoId, PersonalizacionItemUpdateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        this.obtenerDetalle(pedidoId, detallePedidoId);
        PersonalizacionItemPedido personalizacion = (PersonalizacionItemPedido)this.personalizacionRepository.findByDetallePedidoId(detallePedidoId).orElseThrow(() -> new ResourceNotFoundException("Personalizaci\u00f3n no encontrada para el detalle"));
        personalizacion.setDescripcionSolicitud(request.descripcionSolicitud());
        personalizacion.setTextoDedicatoria(request.textoDedicatoria());
        personalizacion.setImagenesReferencia(this.cloneLista(request.imagenesReferencia()));
        personalizacion.setSaborMasa(request.saborMasa());
        personalizacion.setSaborRelleno(request.saborRelleno());
        personalizacion.setTematica(request.tematica());
        personalizacion.setFechaLimiteProduccion(request.fechaLimiteProduccion());
        personalizacion.setCostoExtraPersonalizacionCentimos(request.costoExtraPersonalizacionCentimos());
        PersonalizacionItemPedido actualizada = (PersonalizacionItemPedido)this.personalizacionRepository.save((Object)personalizacion);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long pedidoId, Long detallePedidoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        this.obtenerDetalle(pedidoId, detallePedidoId);
        PersonalizacionItemPedido personalizacion = (PersonalizacionItemPedido)this.personalizacionRepository.findByDetallePedidoId(detallePedidoId).orElseThrow(() -> new ResourceNotFoundException("Personalizaci\u00f3n no encontrada para el detalle"));
        this.personalizacionRepository.delete((Object)personalizacion);
    }

    private DetallePedido obtenerDetalle(Long pedidoId, Long detallePedidoId) {
        return (DetallePedido)this.detallePedidoRepository.findByIdAndPedidoId(detallePedidoId, pedidoId).orElseThrow(() -> new ResourceNotFoundException("Detalle del pedido no encontrado"));
    }

    private List<String> cloneLista(List<String> origen) {
        return origen == null ? new ArrayList<String>() : new ArrayList<String>(origen);
    }

    private PersonalizacionItemResponse toResponse(PersonalizacionItemPedido personalizacion) {
        return PersonalizacionItemResponse.builder().id(personalizacion.getId()).detallePedidoId(personalizacion.getDetallePedidoId()).descripcionSolicitud(personalizacion.getDescripcionSolicitud()).textoDedicatoria(personalizacion.getTextoDedicatoria()).imagenesReferencia(this.cloneLista(personalizacion.getImagenesReferencia())).saborMasa(personalizacion.getSaborMasa()).saborRelleno(personalizacion.getSaborRelleno()).tematica(personalizacion.getTematica()).fechaLimiteProduccion(personalizacion.getFechaLimiteProduccion()).costoExtraPersonalizacionCentimos(personalizacion.getCostoExtraPersonalizacionCentimos()).build();
    }

    @Generated
    public PersonalizacionItemPedidoAdminService(PersonalizacionItemPedidoRepository personalizacionRepository, DetallePedidoRepository detallePedidoRepository, VentasTenantValidator tenantValidator) {
        this.personalizacionRepository = personalizacionRepository;
        this.detallePedidoRepository = detallePedidoRepository;
        this.tenantValidator = tenantValidator;
    }
}

