/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.PagoPedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PagoPedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PagoPedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.PagoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.PagoPedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.SesionCajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.IPagoPedidoAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PagoPedidoAdminService
implements IPagoPedidoAdminService {
    private final PagoPedidoRepository pagoPedidoRepository;
    private final SesionCajaRepository sesionCajaRepository;
    private final VentasTenantValidator tenantValidator;

    @Transactional(readOnly=true)
    public List<PagoPedidoResponse> listar(Long tiendaId, Long pedidoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        return this.pagoPedidoRepository.findByPedidoIdOrderByFechaPagoDesc(pedidoId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public PagoPedidoResponse obtener(Long tiendaId, Long pedidoId, Long pagoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        PagoPedido pago = this.obtenerPago(pedidoId, pagoId);
        return this.toResponse(pago);
    }

    @Transactional
    public PagoPedidoResponse crear(Long tiendaId, Long pedidoId, PagoPedidoCreateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        this.validarSesionPerteneceATienda(tiendaId, request.sesionCajaId());
        PagoPedido pago = new PagoPedido();
        pago.setPedidoId(pedidoId);
        pago.setSesionCajaId(request.sesionCajaId());
        pago.setMontoPagadoCentimos(request.montoPagadoCentimos());
        pago.setMetodoPago(request.metodoPago());
        pago.setReferenciaExterna(request.referenciaExterna());
        pago.setFechaPago(request.fechaPago() != null ? request.fechaPago() : LocalDateTime.now());
        pago.setRegistradoPor(request.registradoPor());
        PagoPedido guardado = (PagoPedido)this.pagoPedidoRepository.save((Object)pago);
        return this.toResponse(guardado);
    }

    @Transactional
    public PagoPedidoResponse actualizar(Long tiendaId, Long pedidoId, Long pagoId, PagoPedidoUpdateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        PagoPedido pago = this.obtenerPago(pedidoId, pagoId);
        this.validarSesionPerteneceATienda(tiendaId, request.sesionCajaId());
        pago.setSesionCajaId(request.sesionCajaId());
        pago.setMontoPagadoCentimos(request.montoPagadoCentimos());
        pago.setMetodoPago(request.metodoPago());
        pago.setReferenciaExterna(request.referenciaExterna());
        pago.setFechaPago(request.fechaPago());
        pago.setRegistradoPor(request.registradoPor());
        PagoPedido actualizado = (PagoPedido)this.pagoPedidoRepository.save((Object)pago);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long pedidoId, Long pagoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        PagoPedido pago = this.obtenerPago(pedidoId, pagoId);
        this.pagoPedidoRepository.delete((Object)pago);
    }

    private void validarSesionPerteneceATienda(Long tiendaId, Long sesionCajaId) {
        if (sesionCajaId == null) {
            return;
        }
        this.sesionCajaRepository.findByIdAndTiendaId(sesionCajaId, tiendaId).orElseThrow(() -> new BadRequestException("La sesi\u00f3n de caja indicada no pertenece a la tienda"));
    }

    private PagoPedido obtenerPago(Long pedidoId, Long pagoId) {
        return (PagoPedido)this.pagoPedidoRepository.findByIdAndPedidoId(pagoId, pedidoId).orElseThrow(() -> new ResourceNotFoundException("Pago del pedido no encontrado"));
    }

    private PagoPedidoResponse toResponse(PagoPedido pago) {
        return PagoPedidoResponse.builder().id(pago.getId()).pedidoId(pago.getPedidoId()).sesionCajaId(pago.getSesionCajaId()).montoPagadoCentimos(pago.getMontoPagadoCentimos()).metodoPago(pago.getMetodoPago()).referenciaExterna(pago.getReferenciaExterna()).fechaPago(pago.getFechaPago()).registradoPor(pago.getRegistradoPor()).build();
    }

    @Generated
    public PagoPedidoAdminService(PagoPedidoRepository pagoPedidoRepository, SesionCajaRepository sesionCajaRepository, VentasTenantValidator tenantValidator) {
        this.pagoPedidoRepository = pagoPedidoRepository;
        this.sesionCajaRepository = sesionCajaRepository;
        this.tenantValidator = tenantValidator;
    }
}

