/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.DireccionPedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DireccionPedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DireccionPedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.DireccionPedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.DireccionPedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.IDireccionPedidoAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DireccionPedidoAdminService
implements IDireccionPedidoAdminService {
    private final DireccionPedidoRepository direccionPedidoRepository;
    private final VentasTenantValidator tenantValidator;

    @Transactional(readOnly=true)
    public List<DireccionPedidoResponse> listar(Long tiendaId, Long pedidoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        return this.direccionPedidoRepository.findByPedidoId(pedidoId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public DireccionPedidoResponse obtener(Long tiendaId, Long pedidoId, Long direccionId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DireccionPedido direccion = this.obtenerDireccion(pedidoId, direccionId);
        return this.toResponse(direccion);
    }

    @Transactional
    public DireccionPedidoResponse crear(Long tiendaId, Long pedidoId, DireccionPedidoCreateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DireccionPedido direccion = new DireccionPedido();
        direccion.setPedidoId(pedidoId);
        direccion.setTipoDireccion(request.tipoDireccion());
        direccion.setNombreContacto(request.nombreContacto());
        direccion.setTipoDocContacto(request.tipoDocContacto());
        direccion.setNumeroDocContacto(request.numeroDocContacto());
        direccion.setTelefonoContacto(request.telefonoContacto());
        direccion.setEmailContacto(request.emailContacto());
        direccion.setDireccionCompleta(request.direccionCompleta());
        direccion.setReferencia(request.referencia());
        direccion.setDistrito(request.distrito());
        direccion.setProvincia(request.provincia());
        direccion.setDepartamento(request.departamento());
        direccion.setCodigoUbigeo(request.codigoUbigeo());
        direccion.setCodigoPostal(request.codigoPostal());
        DireccionPedido guardada = (DireccionPedido)this.direccionPedidoRepository.save((Object)direccion);
        return this.toResponse(guardada);
    }

    @Transactional
    public DireccionPedidoResponse actualizar(Long tiendaId, Long pedidoId, Long direccionId, DireccionPedidoUpdateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DireccionPedido direccion = this.obtenerDireccion(pedidoId, direccionId);
        direccion.setTipoDireccion(request.tipoDireccion());
        direccion.setNombreContacto(request.nombreContacto());
        direccion.setTipoDocContacto(request.tipoDocContacto());
        direccion.setNumeroDocContacto(request.numeroDocContacto());
        direccion.setTelefonoContacto(request.telefonoContacto());
        direccion.setEmailContacto(request.emailContacto());
        direccion.setDireccionCompleta(request.direccionCompleta());
        direccion.setReferencia(request.referencia());
        direccion.setDistrito(request.distrito());
        direccion.setProvincia(request.provincia());
        direccion.setDepartamento(request.departamento());
        direccion.setCodigoUbigeo(request.codigoUbigeo());
        direccion.setCodigoPostal(request.codigoPostal());
        DireccionPedido actualizada = (DireccionPedido)this.direccionPedidoRepository.save((Object)direccion);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long pedidoId, Long direccionId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DireccionPedido direccion = this.obtenerDireccion(pedidoId, direccionId);
        this.direccionPedidoRepository.delete((Object)direccion);
    }

    private DireccionPedido obtenerDireccion(Long pedidoId, Long direccionId) {
        return (DireccionPedido)this.direccionPedidoRepository.findByIdAndPedidoId(direccionId, pedidoId).orElseThrow(() -> new ResourceNotFoundException("Direcci\u00f3n del pedido no encontrada"));
    }

    private DireccionPedidoResponse toResponse(DireccionPedido direccion) {
        return DireccionPedidoResponse.builder().id(direccion.getId()).pedidoId(direccion.getPedidoId()).tipoDireccion(direccion.getTipoDireccion()).nombreContacto(direccion.getNombreContacto()).tipoDocContacto(direccion.getTipoDocContacto()).numeroDocContacto(direccion.getNumeroDocContacto()).telefonoContacto(direccion.getTelefonoContacto()).emailContacto(direccion.getEmailContacto()).direccionCompleta(direccion.getDireccionCompleta()).referencia(direccion.getReferencia()).distrito(direccion.getDistrito()).provincia(direccion.getProvincia()).departamento(direccion.getDepartamento()).codigoUbigeo(direccion.getCodigoUbigeo()).codigoPostal(direccion.getCodigoPostal()).creadoEn(direccion.getCreadoEn()).build();
    }

    @Generated
    public DireccionPedidoAdminService(DireccionPedidoRepository direccionPedidoRepository, VentasTenantValidator tenantValidator) {
        this.direccionPedidoRepository = direccionPedidoRepository;
        this.tenantValidator = tenantValidator;
    }
}

