/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.DetallePedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DetallePedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DetallePedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.DetallePedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.DetallePedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.IDetallePedidoAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DetallePedidoAdminService
implements IDetallePedidoAdminService {
    private final DetallePedidoRepository detallePedidoRepository;
    private final ProductoRepository productoRepository;
    private final VentasTenantValidator tenantValidator;

    @Transactional(readOnly=true)
    public List<DetallePedidoResponse> listar(Long tiendaId, Long pedidoId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        return this.detallePedidoRepository.findByPedidoId(pedidoId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public DetallePedidoResponse obtener(Long tiendaId, Long pedidoId, Long detalleId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DetallePedido detalle = this.obtenerDetalle(pedidoId, detalleId);
        return this.toResponse(detalle);
    }

    @Transactional
    public DetallePedidoResponse crear(Long tiendaId, Long pedidoId, DetallePedidoCreateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        this.validarProductoPerteneceATienda(tiendaId, request.productoId());
        DetallePedido detalle = new DetallePedido();
        detalle.setPedidoId(pedidoId);
        detalle.setProductoId(request.productoId());
        detalle.setCantidad(request.cantidad());
        detalle.setPrecioUnitarioCentimos(request.precioUnitarioCentimos());
        detalle.setSubtotalLineaCentimos(request.subtotalLineaCentimos());
        detalle.setNotasItem(request.notasItem());
        DetallePedido guardado = (DetallePedido)this.detallePedidoRepository.save((Object)detalle);
        return this.toResponse(guardado);
    }

    @Transactional
    public DetallePedidoResponse actualizar(Long tiendaId, Long pedidoId, Long detalleId, DetallePedidoUpdateRequest request) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DetallePedido detalle = this.obtenerDetalle(pedidoId, detalleId);
        this.validarProductoPerteneceATienda(tiendaId, request.productoId());
        detalle.setProductoId(request.productoId());
        detalle.setCantidad(request.cantidad());
        detalle.setPrecioUnitarioCentimos(request.precioUnitarioCentimos());
        detalle.setSubtotalLineaCentimos(request.subtotalLineaCentimos());
        detalle.setNotasItem(request.notasItem());
        DetallePedido actualizado = (DetallePedido)this.detallePedidoRepository.save((Object)detalle);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long pedidoId, Long detalleId) {
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, pedidoId);
        DetallePedido detalle = this.obtenerDetalle(pedidoId, detalleId);
        this.detallePedidoRepository.delete((Object)detalle);
    }

    private DetallePedido obtenerDetalle(Long pedidoId, Long detalleId) {
        return (DetallePedido)this.detallePedidoRepository.findByIdAndPedidoId(detalleId, pedidoId).orElseThrow(() -> new ResourceNotFoundException("Detalle del pedido no encontrado"));
    }

    private void validarProductoPerteneceATienda(Long tiendaId, Long productoId) {
        if (productoId == null) {
            throw new BadRequestException("El producto es obligatorio");
        }
        this.productoRepository.findByIdAndTiendaId(productoId, tiendaId).orElseThrow(() -> new BadRequestException("El producto indicado no pertenece a la tienda"));
    }

    private DetallePedidoResponse toResponse(DetallePedido detalle) {
        return DetallePedidoResponse.builder().id(detalle.getId()).pedidoId(detalle.getPedidoId()).productoId(detalle.getProductoId()).cantidad(detalle.getCantidad()).precioUnitarioCentimos(detalle.getPrecioUnitarioCentimos()).subtotalLineaCentimos(detalle.getSubtotalLineaCentimos()).notasItem(detalle.getNotasItem()).build();
    }

    @Generated
    public DetallePedidoAdminService(DetallePedidoRepository detallePedidoRepository, ProductoRepository productoRepository, VentasTenantValidator tenantValidator) {
        this.detallePedidoRepository = detallePedidoRepository;
        this.productoRepository = productoRepository;
        this.tenantValidator = tenantValidator;
    }
}

