/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.entity;

import io.hypersistence.utils.hibernate.type.json.JsonType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hibernate.annotations.Type;

@Entity
@Table(name="personalizaciones_item_pedido")
public class PersonalizacionItemPedido {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="detalle_pedido_id", nullable=false, unique=true)
    private Long detallePedidoId;
    @Column(name="descripcion_solicitud", nullable=false, columnDefinition="TEXT")
    private String descripcionSolicitud;
    @Column(name="texto_dedicatoria", columnDefinition="TEXT")
    private String textoDedicatoria;
    @Type(value=JsonType.class)
    @Column(name="imagenes_referencia", columnDefinition="json")
    private List<String> imagenesReferencia = new ArrayList();
    @Column(name="sabor_masa", length=100)
    private String saborMasa;
    @Column(name="sabor_relleno", length=100)
    private String saborRelleno;
    @Column(length=100)
    private String tematica;
    @Column(name="fecha_limite_produccion")
    private LocalDateTime fechaLimiteProduccion;
    @Column(name="costo_extra_personalizacion_centimos")
    private Long costoExtraPersonalizacionCentimos = 0L;

    @PrePersist
    void onCreate() {
        if (this.imagenesReferencia == null) {
            this.imagenesReferencia = new ArrayList();
        }
        if (this.costoExtraPersonalizacionCentimos == null) {
            this.costoExtraPersonalizacionCentimos = 0L;
        }
    }

    @PreUpdate
    void onUpdate() {
        if (this.imagenesReferencia == null) {
            this.imagenesReferencia = new ArrayList();
        }
        if (this.costoExtraPersonalizacionCentimos == null) {
            this.costoExtraPersonalizacionCentimos = 0L;
        }
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getDetallePedidoId() {
        return this.detallePedidoId;
    }

    @Generated
    public String getDescripcionSolicitud() {
        return this.descripcionSolicitud;
    }

    @Generated
    public String getTextoDedicatoria() {
        return this.textoDedicatoria;
    }

    @Generated
    public List<String> getImagenesReferencia() {
        return this.imagenesReferencia;
    }

    @Generated
    public String getSaborMasa() {
        return this.saborMasa;
    }

    @Generated
    public String getSaborRelleno() {
        return this.saborRelleno;
    }

    @Generated
    public String getTematica() {
        return this.tematica;
    }

    @Generated
    public LocalDateTime getFechaLimiteProduccion() {
        return this.fechaLimiteProduccion;
    }

    @Generated
    public Long getCostoExtraPersonalizacionCentimos() {
        return this.costoExtraPersonalizacionCentimos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDetallePedidoId(Long detallePedidoId) {
        this.detallePedidoId = detallePedidoId;
    }

    @Generated
    public void setDescripcionSolicitud(String descripcionSolicitud) {
        this.descripcionSolicitud = descripcionSolicitud;
    }

    @Generated
    public void setTextoDedicatoria(String textoDedicatoria) {
        this.textoDedicatoria = textoDedicatoria;
    }

    @Generated
    public void setImagenesReferencia(List<String> imagenesReferencia) {
        this.imagenesReferencia = imagenesReferencia;
    }

    @Generated
    public void setSaborMasa(String saborMasa) {
        this.saborMasa = saborMasa;
    }

    @Generated
    public void setSaborRelleno(String saborRelleno) {
        this.saborRelleno = saborRelleno;
    }

    @Generated
    public void setTematica(String tematica) {
        this.tematica = tematica;
    }

    @Generated
    public void setFechaLimiteProduccion(LocalDateTime fechaLimiteProduccion) {
        this.fechaLimiteProduccion = fechaLimiteProduccion;
    }

    @Generated
    public void setCostoExtraPersonalizacionCentimos(Long costoExtraPersonalizacionCentimos) {
        this.costoExtraPersonalizacionCentimos = costoExtraPersonalizacionCentimos;
    }
}

