/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="cajas")
@SQLDelete(sql="UPDATE cajas SET activa = false WHERE id = ?")
@SQLRestriction(value="activa = true")
public class Caja {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="sede_id", nullable=false)
    private Long sedeId;
    @Column(nullable=false, length=100)
    private String nombre;
    @Column(nullable=false)
    private Boolean activa = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        if (this.activa == null) {
            this.activa = Boolean.TRUE;
        }
        if (this.creadoEn == null) {
            this.creadoEn = LocalDateTime.now();
        }
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getSedeId() {
        return this.sedeId;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public Boolean getActiva() {
        return this.activa;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setSedeId(Long sedeId) {
        this.sedeId = sedeId;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setActiva(Boolean activa) {
        this.activa = activa;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }
}

