/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.PedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPagoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.TipoEntregaPedido;
import com.dulcecontrol.bakery.features.admin.ventas.service.IPedidoAdminService;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/pedidos"})
@Validated
public class PedidoAdminController {
    private final IPedidoAdminService pedidoAdminService;

    @GetMapping
    public ResponseEntity<List<PedidoResponse>> listar(@PathVariable Long tiendaId, @RequestParam(value="sedeId", required=false) Long sedeId, @RequestParam(value="estadoPedido", required=false) EstadoPedido estadoPedido, @RequestParam(value="estadoPago", required=false) EstadoPagoPedido estadoPago, @RequestParam(value="tipoEntrega", required=false) TipoEntregaPedido tipoEntrega, @RequestParam(value="fechaDesde", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaDesde, @RequestParam(value="fechaHasta", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaHasta) {
        List pedidos = this.pedidoAdminService.listar(tiendaId, sedeId, estadoPedido, estadoPago, tipoEntrega, fechaDesde, fechaHasta);
        return ResponseEntity.ok((Object)pedidos);
    }

    @GetMapping(value={"/{pedidoId}"})
    public ResponseEntity<PedidoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long pedidoId) {
        return ResponseEntity.ok((Object)this.pedidoAdminService.obtener(tiendaId, pedidoId));
    }

    @PostMapping
    public ResponseEntity<PedidoResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody PedidoCreateRequest request) {
        PedidoResponse response = this.pedidoAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{pedidoId}"})
    public ResponseEntity<PedidoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @Valid @RequestBody PedidoUpdateRequest request) {
        PedidoResponse response = this.pedidoAdminService.actualizar(tiendaId, pedidoId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{pedidoId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long pedidoId) {
        this.pedidoAdminService.eliminar(tiendaId, pedidoId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public PedidoAdminController(IPedidoAdminService pedidoAdminService) {
        this.pedidoAdminService = pedidoAdminService;
    }
}

