/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.PagoPedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PagoPedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PagoPedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.IPagoPedidoAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/pedidos/{pedidoId}/pagos"})
@Validated
public class PagoPedidoAdminController {
    private final IPagoPedidoAdminService pagoPedidoAdminService;

    @GetMapping
    public ResponseEntity<List<PagoPedidoResponse>> listar(@PathVariable Long tiendaId, @PathVariable Long pedidoId) {
        return ResponseEntity.ok((Object)this.pagoPedidoAdminService.listar(tiendaId, pedidoId));
    }

    @GetMapping(value={"/{pagoId}"})
    public ResponseEntity<PagoPedidoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long pagoId) {
        return ResponseEntity.ok((Object)this.pagoPedidoAdminService.obtener(tiendaId, pedidoId, pagoId));
    }

    @PostMapping
    public ResponseEntity<PagoPedidoResponse> crear(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @Valid @RequestBody PagoPedidoCreateRequest request) {
        PagoPedidoResponse response = this.pagoPedidoAdminService.crear(tiendaId, pedidoId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{pagoId}"})
    public ResponseEntity<PagoPedidoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long pagoId, @Valid @RequestBody PagoPedidoUpdateRequest request) {
        PagoPedidoResponse response = this.pagoPedidoAdminService.actualizar(tiendaId, pedidoId, pagoId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{pagoId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long pagoId) {
        this.pagoPedidoAdminService.eliminar(tiendaId, pedidoId, pagoId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public PagoPedidoAdminController(IPagoPedidoAdminService pagoPedidoAdminService) {
        this.pagoPedidoAdminService = pagoPedidoAdminService;
    }
}

