/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.DireccionPedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DireccionPedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DireccionPedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.IDireccionPedidoAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/pedidos/{pedidoId}/direcciones"})
@Validated
public class DireccionPedidoAdminController {
    private final IDireccionPedidoAdminService direccionPedidoAdminService;

    @GetMapping
    public ResponseEntity<List<DireccionPedidoResponse>> listar(@PathVariable Long tiendaId, @PathVariable Long pedidoId) {
        return ResponseEntity.ok((Object)this.direccionPedidoAdminService.listar(tiendaId, pedidoId));
    }

    @GetMapping(value={"/{direccionId}"})
    public ResponseEntity<DireccionPedidoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long direccionId) {
        return ResponseEntity.ok((Object)this.direccionPedidoAdminService.obtener(tiendaId, pedidoId, direccionId));
    }

    @PostMapping
    public ResponseEntity<DireccionPedidoResponse> crear(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @Valid @RequestBody DireccionPedidoCreateRequest request) {
        DireccionPedidoResponse response = this.direccionPedidoAdminService.crear(tiendaId, pedidoId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{direccionId}"})
    public ResponseEntity<DireccionPedidoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long direccionId, @Valid @RequestBody DireccionPedidoUpdateRequest request) {
        DireccionPedidoResponse response = this.direccionPedidoAdminService.actualizar(tiendaId, pedidoId, direccionId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{direccionId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long direccionId) {
        this.direccionPedidoAdminService.eliminar(tiendaId, pedidoId, direccionId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public DireccionPedidoAdminController(IDireccionPedidoAdminService direccionPedidoAdminService) {
        this.direccionPedidoAdminService = direccionPedidoAdminService;
    }
}

