/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.DetallePedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DetallePedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.DetallePedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.IDetallePedidoAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/pedidos/{pedidoId}/detalles"})
@Validated
public class DetallePedidoAdminController {
    private final IDetallePedidoAdminService detallePedidoAdminService;

    @GetMapping
    public ResponseEntity<List<DetallePedidoResponse>> listar(@PathVariable Long tiendaId, @PathVariable Long pedidoId) {
        return ResponseEntity.ok((Object)this.detallePedidoAdminService.listar(tiendaId, pedidoId));
    }

    @GetMapping(value={"/{detalleId}"})
    public ResponseEntity<DetallePedidoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detalleId) {
        return ResponseEntity.ok((Object)this.detallePedidoAdminService.obtener(tiendaId, pedidoId, detalleId));
    }

    @PostMapping
    public ResponseEntity<DetallePedidoResponse> crear(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @Valid @RequestBody DetallePedidoCreateRequest request) {
        DetallePedidoResponse response = this.detallePedidoAdminService.crear(tiendaId, pedidoId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{detalleId}"})
    public ResponseEntity<DetallePedidoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detalleId, @Valid @RequestBody DetallePedidoUpdateRequest request) {
        DetallePedidoResponse response = this.detallePedidoAdminService.actualizar(tiendaId, pedidoId, detalleId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{detalleId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detalleId) {
        this.detallePedidoAdminService.eliminar(tiendaId, pedidoId, detalleId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public DetallePedidoAdminController(IDetallePedidoAdminService detallePedidoAdminService) {
        this.detallePedidoAdminService = detallePedidoAdminService;
    }
}

