/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ubigeo.service.impl;

import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoDepartamentoResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoDistritoResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoProvinciaResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoRutaResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.service.IUbigeoAdminService;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoDepartamento;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoDistrito;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoProvincia;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoDepartamentoRepository;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoDistritoRepository;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoProvinciaRepository;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UbigeoAdminService
implements IUbigeoAdminService {
    private final UbigeoDepartamentoRepository departamentoRepository;
    private final UbigeoProvinciaRepository provinciaRepository;
    private final UbigeoDistritoRepository distritoRepository;

    public List<UbigeoDepartamentoResponse> listarDepartamentos() {
        return this.departamentoRepository.findAllByOrderByNombreAsc().stream().map(UbigeoDepartamentoResponse::fromEntity).toList();
    }

    public List<UbigeoProvinciaResponse> listarProvinciasPorDepartamento(Long departamentoId) {
        return this.provinciaRepository.findByDepartamentoIdOrderByNombreAsc(departamentoId).stream().map(UbigeoProvinciaResponse::fromEntity).toList();
    }

    public List<UbigeoDistritoResponse> listarDistritosPorProvincia(Long provinciaId) {
        return this.distritoRepository.findByProvinciaIdOrderByNombreAsc(provinciaId).stream().map(UbigeoDistritoResponse::fromEntity).toList();
    }

    public UbigeoRutaResponse obtenerRutaPorDistrito(Long distritoId) {
        UbigeoDistrito distrito = (UbigeoDistrito)this.distritoRepository.findById((Object)distritoId).orElseThrow(() -> new ResourceNotFoundException("Distrito no encontrado"));
        UbigeoProvincia provincia = (UbigeoProvincia)this.provinciaRepository.findById((Object)distrito.getProvincia().getId()).orElseThrow(() -> new ResourceNotFoundException("Provincia no encontrada para el distrito"));
        UbigeoDepartamento departamento = (UbigeoDepartamento)this.departamentoRepository.findById((Object)provincia.getDepartamento().getId()).orElseThrow(() -> new ResourceNotFoundException("Departamento no encontrado para la provincia"));
        return UbigeoRutaResponse.builder().departamento(UbigeoDepartamentoResponse.fromEntity((UbigeoDepartamento)departamento)).provincia(UbigeoProvinciaResponse.fromEntity((UbigeoProvincia)provincia)).distrito(UbigeoDistritoResponse.fromEntity((UbigeoDistrito)distrito)).build();
    }

    @Generated
    public UbigeoAdminService(UbigeoDepartamentoRepository departamentoRepository, UbigeoProvinciaRepository provinciaRepository, UbigeoDistritoRepository distritoRepository) {
        this.departamentoRepository = departamentoRepository;
        this.provinciaRepository = provinciaRepository;
        this.distritoRepository = distritoRepository;
    }
}

