/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.AuditoriaUsuarioResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.AuditoriaUsuario;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioTienda;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.AuditoriaUsuarioRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IAuditoriaUsuarioService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditoriaUsuarioService
implements IAuditoriaUsuarioService {
    private final AuditoriaUsuarioRepository auditoriaRepository;
    private final UsuarioTiendaRepository usuarioRepository;

    @Transactional
    public void registrarAccion(Long tiendaId, Long usuarioId, String accion, String entidad, Long entidadId, Map<String, Object> valoresAnteriores, Map<String, Object> valoresNuevos, String ipOrigen, String userAgent) {
        AuditoriaUsuario auditoria = new AuditoriaUsuario();
        auditoria.setTiendaId(tiendaId);
        auditoria.setUsuarioId(usuarioId);
        auditoria.setAccion(accion);
        auditoria.setEntidad(entidad);
        auditoria.setEntidadId(entidadId);
        auditoria.setValoresAnteriores(valoresAnteriores);
        auditoria.setValoresNuevos(valoresNuevos);
        auditoria.setIpOrigen(ipOrigen);
        auditoria.setUserAgent(userAgent);
        this.auditoriaRepository.save((Object)auditoria);
    }

    @Transactional(readOnly=true)
    public List<AuditoriaUsuarioResponse> listarPorTienda(Long tiendaId) {
        return this.auditoriaRepository.findByTiendaIdOrderByCreadoEnDesc(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public Page<AuditoriaUsuarioResponse> listarPorTiendaPaginado(Long tiendaId, Pageable pageable) {
        return this.auditoriaRepository.findByTiendaIdOrderByCreadoEnDesc(tiendaId, pageable).map(arg_0 -> this.toResponse(arg_0));
    }

    @Transactional(readOnly=true)
    public List<AuditoriaUsuarioResponse> listarPorUsuario(Long usuarioId) {
        return this.auditoriaRepository.findByUsuarioIdOrderByCreadoEnDesc(usuarioId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<AuditoriaUsuarioResponse> listarPorRangoFechas(Long tiendaId, LocalDateTime inicio, LocalDateTime fin) {
        return this.auditoriaRepository.findByTiendaIdAndCreadoEnBetweenOrderByCreadoEnDesc(tiendaId, inicio, fin).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    private AuditoriaUsuarioResponse toResponse(AuditoriaUsuario auditoria) {
        String usuarioNombre = null;
        if (auditoria.getUsuarioId() != null) {
            Optional usuario = this.usuarioRepository.findById((Object)auditoria.getUsuarioId());
            usuarioNombre = usuario.map(UsuarioTienda::getNombres).orElse(null);
        }
        return AuditoriaUsuarioResponse.builder().id(auditoria.getId()).tiendaId(auditoria.getTiendaId()).usuarioId(auditoria.getUsuarioId()).usuarioNombre(usuarioNombre).accion(auditoria.getAccion()).entidad(auditoria.getEntidad()).entidadId(auditoria.getEntidadId()).valoresAnteriores(auditoria.getValoresAnteriores()).valoresNuevos(auditoria.getValoresNuevos()).ipOrigen(auditoria.getIpOrigen()).creadoEn(auditoria.getCreadoEn()).build();
    }

    @Generated
    public AuditoriaUsuarioService(AuditoriaUsuarioRepository auditoriaRepository, UsuarioTiendaRepository usuarioRepository) {
        this.auditoriaRepository = auditoriaRepository;
        this.usuarioRepository = usuarioRepository;
    }
}

