/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.controller;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.AsignarSedesRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioSedeResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IUsuarioSedeService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/seguridad/usuarios/{usuarioId}/sedes"})
@Validated
public class UsuarioSedeController {
    private final IUsuarioSedeService usuarioSedeService;

    @GetMapping
    public ResponseEntity<List<UsuarioSedeResponse>> obtenerSedes(@PathVariable Long tiendaId, @PathVariable Long usuarioId) {
        return ResponseEntity.ok((Object)this.usuarioSedeService.obtenerSedesPorUsuario(tiendaId, usuarioId));
    }

    @PostMapping
    public ResponseEntity<List<UsuarioSedeResponse>> asignarSedes(@PathVariable Long tiendaId, @PathVariable Long usuarioId, @Valid @RequestBody AsignarSedesRequest request) {
        List response = this.usuarioSedeService.asignarSedes(tiendaId, usuarioId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{sedeId}"})
    public ResponseEntity<Void> removerSede(@PathVariable Long tiendaId, @PathVariable Long usuarioId, @PathVariable Long sedeId) {
        this.usuarioSedeService.removerSede(tiendaId, usuarioId, sedeId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public UsuarioSedeController(IUsuarioSedeService usuarioSedeService) {
        this.usuarioSedeService = usuarioSedeService;
    }
}

