/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.controller;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioCreateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IUsuarioAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/seguridad/usuarios"})
@Validated
public class UsuarioAdminController {
    private final IUsuarioAdminService usuarioAdminService;

    @GetMapping
    public ResponseEntity<List<UsuarioResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.usuarioAdminService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{usuarioId}"})
    public ResponseEntity<UsuarioResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long usuarioId) {
        return ResponseEntity.ok((Object)this.usuarioAdminService.obtenerPorId(tiendaId, usuarioId));
    }

    @PostMapping
    public ResponseEntity<UsuarioResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody UsuarioCreateRequest request) {
        UsuarioResponse response = this.usuarioAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{usuarioId}"})
    public ResponseEntity<UsuarioResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long usuarioId, @Valid @RequestBody UsuarioUpdateRequest request) {
        UsuarioResponse response = this.usuarioAdminService.actualizar(tiendaId, usuarioId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{usuarioId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long usuarioId) {
        this.usuarioAdminService.eliminar(tiendaId, usuarioId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public UsuarioAdminController(IUsuarioAdminService usuarioAdminService) {
        this.usuarioAdminService = usuarioAdminService;
    }
}

