/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.controller;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.RolCreateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.RolResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.RolUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IRolAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/seguridad/roles"})
@Validated
public class RolAdminController {
    private final IRolAdminService rolAdminService;

    @GetMapping
    public ResponseEntity<List<RolResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.rolAdminService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{rolId}"})
    public ResponseEntity<RolResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long rolId) {
        return ResponseEntity.ok((Object)this.rolAdminService.obtenerPorId(tiendaId, rolId));
    }

    @PostMapping
    public ResponseEntity<RolResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody RolCreateRequest request) {
        RolResponse response = this.rolAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{rolId}"})
    public ResponseEntity<RolResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long rolId, @Valid @RequestBody RolUpdateRequest request) {
        RolResponse response = this.rolAdminService.actualizar(tiendaId, rolId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{rolId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long rolId) {
        this.rolAdminService.eliminar(tiendaId, rolId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public RolAdminController(IRolAdminService rolAdminService) {
        this.rolAdminService = rolAdminService;
    }
}

