/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.controller;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.AuditoriaUsuarioResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IAuditoriaUsuarioService;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/seguridad/auditoria"})
public class AuditoriaUsuarioController {
    private final IAuditoriaUsuarioService auditoriaService;

    @GetMapping
    public ResponseEntity<Page<AuditoriaUsuarioResponse>> listarPaginado(@PathVariable Long tiendaId, @PageableDefault(size=50, sort={"creadoEn"}, direction=Sort.Direction.DESC) Pageable pageable) {
        return ResponseEntity.ok((Object)this.auditoriaService.listarPorTiendaPaginado(tiendaId, pageable));
    }

    @GetMapping(value={"/usuario/{usuarioId}"})
    public ResponseEntity<List<AuditoriaUsuarioResponse>> listarPorUsuario(@PathVariable Long usuarioId) {
        return ResponseEntity.ok((Object)this.auditoriaService.listarPorUsuario(usuarioId));
    }

    @GetMapping(value={"/rango"})
    public ResponseEntity<List<AuditoriaUsuarioResponse>> listarPorRangoFechas(@PathVariable Long tiendaId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime inicio, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fin) {
        return ResponseEntity.ok((Object)this.auditoriaService.listarPorRangoFechas(tiendaId, inicio, fin));
    }

    @Generated
    public AuditoriaUsuarioController(IAuditoriaUsuarioService auditoriaService) {
        this.auditoriaService = auditoriaService;
    }
}

