/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.service.impl;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.admin.compras.entity.Insumo;
import com.dulcecontrol.bakery.features.admin.compras.repository.InsumoRepository;
import com.dulcecontrol.bakery.features.admin.produccion.dto.RecetaCreateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.RecetaResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.RecetaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.entity.Receta;
import com.dulcecontrol.bakery.features.admin.produccion.repository.RecetaRepository;
import com.dulcecontrol.bakery.features.admin.produccion.service.IRecetaAdminService;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecetaAdminService
implements IRecetaAdminService {
    private final RecetaRepository recetaRepository;
    private final ProductoRepository productoRepository;
    private final InsumoRepository insumoRepository;

    @Transactional(readOnly=true)
    public List<RecetaResponse> listarPorTienda(Long tiendaId) {
        List recetas = this.recetaRepository.findByTiendaId(tiendaId);
        if (recetas.isEmpty()) {
            return List.of();
        }
        Set productoIds = recetas.stream().map(Receta::getProductoId).collect(Collectors.toSet());
        Map<Long, Producto> productosMap = this.productoRepository.findAllById(productoIds).stream().filter(p -> p.getTiendaId().equals(tiendaId)).collect(Collectors.toMap(Producto::getId, p -> p));
        Set insumoIds = recetas.stream().map(Receta::getInsumoId).collect(Collectors.toSet());
        Map<Long, Insumo> insumosMap = this.insumoRepository.findAllById(insumoIds).stream().filter(i -> i.getTiendaId().equals(tiendaId)).collect(Collectors.toMap(Insumo::getId, i -> i));
        return recetas.stream().map(receta -> this.toResponse(receta, productosMap, insumosMap)).toList();
    }

    @Transactional(readOnly=true)
    public RecetaResponse obtenerPorId(Long tiendaId, Long recetaId) {
        Receta receta = this.obtenerEntidad(tiendaId, recetaId);
        Producto producto = this.productoRepository.findById((Object)receta.getProductoId()).orElse(null);
        Insumo insumo = this.insumoRepository.findById((Object)receta.getInsumoId()).orElse(null);
        return this.toResponse(receta, producto, insumo);
    }

    @Transactional
    public RecetaResponse crear(Long tiendaId, RecetaCreateRequest request) {
        this.validarUnicidad(tiendaId, null, request.getProductoId(), request.getInsumoId());
        Receta receta = new Receta();
        receta.setTiendaId(tiendaId);
        receta.setProductoId(request.getProductoId());
        receta.setInsumoId(request.getInsumoId());
        receta.setCantidadRequerida(request.getCantidadRequerida());
        receta.setUnidadMedida(request.getUnidadMedida());
        receta.setNotasPreparacion(request.getNotasPreparacion());
        Receta guardada = (Receta)this.recetaRepository.save((Object)receta);
        Producto producto = this.productoRepository.findById((Object)guardada.getProductoId()).orElse(null);
        Insumo insumo = this.insumoRepository.findById((Object)guardada.getInsumoId()).orElse(null);
        return this.toResponse(guardada, producto, insumo);
    }

    @Transactional
    public RecetaResponse actualizar(Long tiendaId, Long recetaId, RecetaUpdateRequest request) {
        Receta receta = this.obtenerEntidad(tiendaId, recetaId);
        this.validarUnicidad(tiendaId, recetaId, request.getProductoId(), request.getInsumoId());
        receta.setProductoId(request.getProductoId());
        receta.setInsumoId(request.getInsumoId());
        receta.setCantidadRequerida(request.getCantidadRequerida());
        receta.setUnidadMedida(request.getUnidadMedida());
        receta.setNotasPreparacion(request.getNotasPreparacion());
        Receta actualizada = (Receta)this.recetaRepository.save((Object)receta);
        Producto producto = this.productoRepository.findById((Object)actualizada.getProductoId()).orElse(null);
        Insumo insumo = this.insumoRepository.findById((Object)actualizada.getInsumoId()).orElse(null);
        return this.toResponse(actualizada, producto, insumo);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long recetaId) {
        Receta receta = this.obtenerEntidad(tiendaId, recetaId);
        this.recetaRepository.delete((Object)receta);
    }

    private void validarUnicidad(Long tiendaId, Long recetaId, Long productoId, Long insumoId) {
        boolean existe = recetaId == null ? this.recetaRepository.existsByTiendaIdAndProductoIdAndInsumoId(tiendaId, productoId, insumoId) : this.recetaRepository.existsByTiendaIdAndProductoIdAndInsumoIdAndIdNot(tiendaId, productoId, insumoId, recetaId);
        if (existe) {
            throw new BadRequestException("Ya existe una receta registrada para este producto e insumo");
        }
    }

    private Receta obtenerEntidad(Long tiendaId, Long recetaId) {
        return (Receta)this.recetaRepository.findByIdAndTiendaId(recetaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("La receta solicitada no existe"));
    }

    private RecetaResponse toResponse(Receta receta, Map<Long, Producto> productosMap, Map<Long, Insumo> insumosMap) {
        Producto producto = productosMap.get(receta.getProductoId());
        Insumo insumo = insumosMap.get(receta.getInsumoId());
        return this.toResponse(receta, producto, insumo);
    }

    private RecetaResponse toResponse(Receta receta, Producto producto, Insumo insumo) {
        return RecetaResponse.builder().id(receta.getId()).tiendaId(receta.getTiendaId()).productoId(receta.getProductoId()).productoNombre(producto != null ? producto.getNombre() : null).productoSku(producto != null ? producto.getSku() : null).insumoId(receta.getInsumoId()).insumoNombre(insumo != null ? insumo.getNombre() : null).insumoCodigoInterno(insumo != null ? insumo.getCodigoInterno() : null).cantidadRequerida(receta.getCantidadRequerida()).unidadMedida(receta.getUnidadMedida()).notasPreparacion(receta.getNotasPreparacion()).creadoEn(receta.getCreadoEn()).build();
    }

    @Generated
    public RecetaAdminService(RecetaRepository recetaRepository, ProductoRepository productoRepository, InsumoRepository insumoRepository) {
        this.recetaRepository = recetaRepository;
        this.productoRepository = productoRepository;
        this.insumoRepository = insumoRepository;
    }
}

