/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.service;

import com.dulcecontrol.bakery.features.admin.produccion.dto.ConteoDiarioCreateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.ConteoDiarioResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.DetalleConteoDiarioResponse;
import com.dulcecontrol.bakery.features.admin.produccion.entity.ConteoDiario;
import com.dulcecontrol.bakery.features.admin.produccion.entity.DetalleConteoDiario;
import com.dulcecontrol.bakery.features.admin.produccion.repository.ConteoDiarioRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.DetalleConteoDiarioRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConteoDiarioAdminService {
    private final ConteoDiarioRepository conteoRepository;
    private final DetalleConteoDiarioRepository detalleRepository;
    private final ProductoRepository productoRepository;

    @Transactional
    public ConteoDiarioResponse createConteo(Long tiendaId, ConteoDiarioCreateRequest request) {
        ConteoDiario conteo;
        Optional existing = this.conteoRepository.findBySedeIdAndFechaConteo(request.getSedeId(), request.getFechaConteo());
        if (existing.isPresent()) {
            conteo = (ConteoDiario)existing.get();
            conteo.setResponsableId(request.getResponsableId());
            conteo.setObservaciones(request.getObservaciones());
            this.detalleRepository.deleteByConteoId(conteo.getId());
        } else {
            conteo = new ConteoDiario();
            conteo.setTiendaId(tiendaId);
            conteo.setSedeId(request.getSedeId());
            conteo.setFechaConteo(request.getFechaConteo());
            conteo.setResponsableId(request.getResponsableId());
            conteo.setObservaciones(request.getObservaciones());
            conteo = (ConteoDiario)this.conteoRepository.save((Object)conteo);
        }
        Long conteoId = conteo.getId();
        List detalles = request.getDetalles().stream().map(item -> {
            DetalleConteoDiario detalle = new DetalleConteoDiario();
            detalle.setConteoId(conteoId);
            detalle.setProductoId(item.getProductoId());
            detalle.setCantidadFisica(item.getCantidadFisica());
            detalle.setCantidadSistema(item.getCantidadSistema());
            return detalle;
        }).collect(Collectors.toList());
        this.detalleRepository.saveAll(detalles);
        return this.toResponse(conteo, detalles);
    }

    @Transactional(readOnly=true)
    public List<ConteoDiarioResponse> listConteosBySedeId(Long tiendaId, Long sedeId) {
        List conteos = this.conteoRepository.findByTiendaIdAndSedeIdOrderByFechaConteoDesc(tiendaId, sedeId);
        return conteos.stream().map(conteo -> {
            List detalles = this.detalleRepository.findByConteoIdOrderByIdAsc(conteo.getId());
            return this.toResponse(conteo, detalles);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Optional<ConteoDiarioResponse> getConteoBySedeAndFecha(Long tiendaId, Long sedeId, LocalDate fecha) {
        return this.conteoRepository.findBySedeIdAndFechaConteo(sedeId, fecha).map(conteo -> {
            List detalles = this.detalleRepository.findByConteoIdOrderByIdAsc(conteo.getId());
            return this.toResponse(conteo, detalles);
        });
    }

    private ConteoDiarioResponse toResponse(ConteoDiario conteo, List<DetalleConteoDiario> detalles) {
        List productoIds = detalles.stream().map(DetalleConteoDiario::getProductoId).distinct().collect(Collectors.toList());
        Map<Long, String> productoNames = this.productoRepository.findAllById(productoIds).stream().collect(Collectors.toMap(p -> p.getId(), p -> p.getNombre(), (a, b) -> a));
        ConteoDiarioResponse response = new ConteoDiarioResponse();
        response.setId(conteo.getId());
        response.setTiendaId(conteo.getTiendaId());
        response.setSedeId(conteo.getSedeId());
        response.setFechaConteo(conteo.getFechaConteo());
        response.setResponsableId(conteo.getResponsableId());
        response.setObservaciones(conteo.getObservaciones());
        response.setCreadoEn(conteo.getCreadoEn());
        List detalleResponses = detalles.stream().map(detalle -> {
            DetalleConteoDiarioResponse dr = new DetalleConteoDiarioResponse();
            dr.setId(detalle.getId());
            dr.setProductoId(detalle.getProductoId());
            dr.setProductoNombre((String)productoNames.get(detalle.getProductoId()));
            dr.setCantidadFisica(detalle.getCantidadFisica());
            dr.setCantidadSistema(detalle.getCantidadSistema());
            dr.setDiferencia(detalle.getDiferencia());
            return dr;
        }).collect(Collectors.toList());
        response.setDetalles(detalleResponses);
        return response;
    }

    @Generated
    public ConteoDiarioAdminService(ConteoDiarioRepository conteoRepository, DetalleConteoDiarioRepository detalleRepository, ProductoRepository productoRepository) {
        this.conteoRepository = conteoRepository;
        this.detalleRepository = detalleRepository;
        this.productoRepository = productoRepository;
    }
}

