/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.entity;

import com.dulcecontrol.bakery.features.admin.produccion.entity.converter.UnidadMedidaRecetaConverter;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.UnidadMedidaReceta;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="recetas")
public class Receta {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="producto_id", nullable=false)
    private Long productoId;
    @Column(name="insumo_id", nullable=false)
    private Long insumoId;
    @Column(name="cantidad_requerida", nullable=false, precision=12, scale=4)
    private BigDecimal cantidadRequerida;
    @Convert(converter=UnidadMedidaRecetaConverter.class)
    @Column(name="unidad_medida", nullable=false, length=20)
    private UnidadMedidaReceta unidadMedida;
    @Column(name="notas_preparacion")
    private String notasPreparacion;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getProductoId() {
        return this.productoId;
    }

    @Generated
    public Long getInsumoId() {
        return this.insumoId;
    }

    @Generated
    public BigDecimal getCantidadRequerida() {
        return this.cantidadRequerida;
    }

    @Generated
    public UnidadMedidaReceta getUnidadMedida() {
        return this.unidadMedida;
    }

    @Generated
    public String getNotasPreparacion() {
        return this.notasPreparacion;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setProductoId(Long productoId) {
        this.productoId = productoId;
    }

    @Generated
    public void setInsumoId(Long insumoId) {
        this.insumoId = insumoId;
    }

    @Generated
    public void setCantidadRequerida(BigDecimal cantidadRequerida) {
        this.cantidadRequerida = cantidadRequerida;
    }

    @Generated
    public void setUnidadMedida(UnidadMedidaReceta unidadMedida) {
        this.unidadMedida = unidadMedida;
    }

    @Generated
    public void setNotasPreparacion(String notasPreparacion) {
        this.notasPreparacion = notasPreparacion;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }
}

