/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.controller;

import com.dulcecontrol.bakery.features.admin.produccion.dto.ConteoDiarioCreateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.ConteoDiarioResponse;
import com.dulcecontrol.bakery.features.admin.produccion.service.ConteoDiarioAdminService;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/produccion/conteos-diarios"})
@Validated
public class ConteoDiarioAdminController {
    private final ConteoDiarioAdminService conteoService;

    @PostMapping
    public ResponseEntity<ConteoDiarioResponse> crearConteo(@PathVariable Long tiendaId, @Valid @RequestBody ConteoDiarioCreateRequest request) {
        ConteoDiarioResponse response = this.conteoService.createConteo(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping
    public ResponseEntity<List<ConteoDiarioResponse>> listarConteos(@PathVariable Long tiendaId, @RequestParam Long sedeId) {
        List conteos = this.conteoService.listConteosBySedeId(tiendaId, sedeId);
        return ResponseEntity.ok((Object)conteos);
    }

    @GetMapping(value={"/{fecha}"})
    public ResponseEntity<ConteoDiarioResponse> obtenerConteo(@PathVariable Long tiendaId, @PathVariable @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fecha, @RequestParam Long sedeId) {
        Optional conteo = this.conteoService.getConteoBySedeAndFecha(tiendaId, sedeId, fecha);
        return conteo.map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @Generated
    public ConteoDiarioAdminController(ConteoDiarioAdminService conteoService) {
        this.conteoService = conteoService;
    }
}

