/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.service.impl;

import com.dulcecontrol.bakery.features.admin.inventario.dto.ItemTransferenciaCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.ItemTransferenciaRecepcionRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.ItemTransferenciaResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaInventarioCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaInventarioResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaInventarioUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaRecepcionRequest;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioInsumoSede;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.ItemTransferencia;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.TransferenciaInventario;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.EstadoTransferencia;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.MotivoMovimientoProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.TipoMovimientoInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioInsumoSedeRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.ItemTransferenciaRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioInsumoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.TransferenciaInventarioRepository;
import com.dulcecontrol.bakery.features.admin.inventario.service.ITransferenciaInventarioService;
import com.dulcecontrol.bakery.features.admin.inventario.service.impl.TransferenciaInventarioService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferenciaInventarioService
implements ITransferenciaInventarioService {
    private final TransferenciaInventarioRepository repository;
    private final ItemTransferenciaRepository itemRepository;
    private final InventarioProductoRepository inventarioProductoRepository;
    private final InventarioInsumoSedeRepository inventarioInsumoSedeRepository;
    private final MovimientoInventarioProductoRepository movimientoInventarioProductoRepository;
    private final MovimientoInventarioInsumoRepository movimientoInventarioInsumoRepository;

    @Transactional(readOnly=true)
    public List<TransferenciaInventarioResponse> listarPorTienda(Long tiendaId) {
        return this.repository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<TransferenciaInventarioResponse> listarPorEstado(Long tiendaId, EstadoTransferencia estado) {
        return this.repository.findByTiendaIdAndEstado(tiendaId, estado).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public TransferenciaInventarioResponse obtenerPorId(Long tiendaId, Long id) {
        TransferenciaInventario transferencia = (TransferenciaInventario)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Transferencia no encontrada"));
        return this.toResponse(transferencia);
    }

    @Transactional
    public TransferenciaInventarioResponse crear(Long tiendaId, TransferenciaInventarioCreateRequest request) {
        if (request.getSedeOrigenId().equals(request.getSedeDestinoId())) {
            throw new BadRequestException("La sede de origen y destino deben ser diferentes");
        }
        TransferenciaInventario transferencia = new TransferenciaInventario();
        transferencia.setTiendaId(tiendaId);
        transferencia.setSedeOrigenId(request.getSedeOrigenId());
        transferencia.setSedeDestinoId(request.getSedeDestinoId());
        transferencia.setEstado(EstadoTransferencia.PENDIENTE);
        transferencia.setSolicitadoPor(request.getSolicitadoPor());
        transferencia.setObservaciones(request.getObservaciones());
        TransferenciaInventario guardado = (TransferenciaInventario)this.repository.save((Object)transferencia);
        if (request.getItems() != null && !request.getItems().isEmpty()) {
            for (ItemTransferenciaCreateRequest itemRequest : request.getItems()) {
                ItemTransferencia item = new ItemTransferencia();
                item.setTransferenciaId(guardado.getId());
                item.setInsumoId(itemRequest.getInsumoId());
                item.setProductoId(itemRequest.getProductoId());
                item.setCantidadEnviada(itemRequest.getCantidadEnviada());
                this.itemRepository.save((Object)item);
            }
        }
        return this.toResponse(guardado);
    }

    @Transactional
    public TransferenciaInventarioResponse actualizar(Long tiendaId, Long id, TransferenciaInventarioUpdateRequest request) {
        TransferenciaInventario transferencia = (TransferenciaInventario)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Transferencia no encontrada"));
        if (transferencia.getEstado() != EstadoTransferencia.PENDIENTE) {
            throw new BadRequestException("Solo se pueden actualizar transferencias en estado PENDIENTE");
        }
        transferencia.setSedeOrigenId(request.getSedeOrigenId());
        transferencia.setSedeDestinoId(request.getSedeDestinoId());
        transferencia.setObservaciones(request.getObservaciones());
        TransferenciaInventario actualizado = (TransferenciaInventario)this.repository.save((Object)transferencia);
        if (request.getItems() != null) {
            this.itemRepository.deleteByTransferenciaId(id);
            for (ItemTransferenciaCreateRequest itemRequest : request.getItems()) {
                ItemTransferencia item = new ItemTransferencia();
                item.setTransferenciaId(actualizado.getId());
                item.setInsumoId(itemRequest.getInsumoId());
                item.setProductoId(itemRequest.getProductoId());
                item.setCantidadEnviada(itemRequest.getCantidadEnviada());
                this.itemRepository.save((Object)item);
            }
        }
        return this.toResponse(actualizado);
    }

    @Transactional
    public TransferenciaInventarioResponse cambiarEstado(Long tiendaId, Long id, EstadoTransferencia nuevoEstado) {
        TransferenciaInventario transferencia = (TransferenciaInventario)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Transferencia no encontrada"));
        EstadoTransferencia estadoAnterior = transferencia.getEstado();
        this.validarTransicionEstado(estadoAnterior, nuevoEstado);
        List items = this.itemRepository.findByTransferenciaId(transferencia.getId());
        if (estadoAnterior == EstadoTransferencia.PENDIENTE && nuevoEstado == EstadoTransferencia.EN_TRANSITO) {
            this.aplicarSalidaOrigen(tiendaId, transferencia, items);
        }
        if (estadoAnterior == EstadoTransferencia.EN_TRANSITO && nuevoEstado == EstadoTransferencia.RECIBIDO) {
            this.aplicarEntradaDestino(tiendaId, transferencia, items);
        }
        if (estadoAnterior == EstadoTransferencia.EN_TRANSITO && nuevoEstado == EstadoTransferencia.CANCELADO) {
            this.revertirSalidaOrigen(tiendaId, transferencia, items);
        }
        transferencia.setEstado(nuevoEstado);
        switch (1.$SwitchMap$com$dulcecontrol$bakery$features$admin$inventario$entity$enums$EstadoTransferencia[nuevoEstado.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                transferencia.setFechaEnvio(LocalDateTime.now());
                break;
            }
            case 3: {
                transferencia.setFechaRecepcion(LocalDateTime.now());
                break;
            }
        }
        TransferenciaInventario actualizado = (TransferenciaInventario)this.repository.save((Object)transferencia);
        return this.toResponse(actualizado);
    }

    private void aplicarSalidaOrigen(Long tiendaId, TransferenciaInventario transferencia, List<ItemTransferencia> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        Long sedeOrigenId = transferencia.getSedeOrigenId();
        for (ItemTransferencia item : items) {
            Number posterior;
            Number anterior;
            InventarioProducto inventario;
            Number cantidad;
            if (item.getProductoId() != null) {
                cantidad = this.convertirCantidadProducto(item.getCantidadEnviada());
                inventario = this.inventarioProductoRepository.findBySedeIdAndProductoId(sedeOrigenId, item.getProductoId()).orElseGet(() -> {
                    InventarioProducto nuevo = new InventarioProducto();
                    nuevo.setTiendaId(tiendaId);
                    nuevo.setSedeId(sedeOrigenId);
                    nuevo.setProductoId(item.getProductoId());
                    nuevo.setCantidadActual(Integer.valueOf(0));
                    return (InventarioProducto)this.inventarioProductoRepository.save((Object)nuevo);
                });
                anterior = inventario.getCantidadActual();
                posterior = (Integer)anterior - (Integer)cantidad;
                if ((Integer)posterior < 0) {
                    throw new BadRequestException("No hay suficiente stock para enviar el producto (ID " + item.getProductoId() + "). Stock actual: " + (Integer)anterior);
                }
                inventario.setCantidadActual((Integer)posterior);
                this.inventarioProductoRepository.save((Object)inventario);
                this.registrarMovimientoProducto(tiendaId, sedeOrigenId, item.getProductoId(), TipoMovimientoInsumo.SALIDA, (Integer)cantidad, (Integer)anterior, (Integer)posterior);
            }
            if (item.getInsumoId() == null) continue;
            cantidad = item.getCantidadEnviada();
            if (cantidad == null || ((BigDecimal)cantidad).compareTo(BigDecimal.ZERO) <= 0) {
                throw new BadRequestException("La cantidad enviada del insumo es inv\u00e1lida");
            }
            inventario = this.inventarioInsumoSedeRepository.findBySedeIdAndInsumoId(sedeOrigenId, item.getInsumoId()).orElseGet(() -> {
                InventarioInsumoSede nuevo = new InventarioInsumoSede();
                nuevo.setTiendaId(tiendaId);
                nuevo.setSedeId(sedeOrigenId);
                nuevo.setInsumoId(item.getInsumoId());
                nuevo.setCantidadActual(BigDecimal.ZERO);
                return (InventarioInsumoSede)this.inventarioInsumoSedeRepository.save((Object)nuevo);
            });
            anterior = inventario.getCantidadActual();
            posterior = ((BigDecimal)anterior).subtract((BigDecimal)cantidad);
            if (((BigDecimal)posterior).compareTo(BigDecimal.ZERO) < 0) {
                throw new BadRequestException("No hay suficiente stock para enviar el insumo (ID " + item.getInsumoId() + "). Stock actual: " + String.valueOf(anterior));
            }
            inventario.setCantidadActual((BigDecimal)posterior);
            this.inventarioInsumoSedeRepository.save((Object)inventario);
            this.registrarMovimientoInsumo(tiendaId, sedeOrigenId, item.getInsumoId(), TipoMovimientoInsumo.SALIDA, (BigDecimal)cantidad, (BigDecimal)anterior, (BigDecimal)posterior, transferencia.getId(), "Transferencia #" + transferencia.getId() + " (salida)");
        }
    }

    private void aplicarEntradaDestino(Long tiendaId, TransferenciaInventario transferencia, List<ItemTransferencia> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        Long sedeDestinoId = transferencia.getSedeDestinoId();
        for (ItemTransferencia item : items) {
            Number posterior;
            Number anterior;
            InventarioProducto inventario;
            Number cantidad;
            BigDecimal cantidadRecibida = item.getCantidadRecibida();
            if (cantidadRecibida == null) {
                cantidadRecibida = item.getCantidadEnviada();
                item.setCantidadRecibida(cantidadRecibida);
                this.itemRepository.save((Object)item);
            }
            if (item.getProductoId() != null) {
                cantidad = this.convertirCantidadProducto(cantidadRecibida);
                inventario = this.inventarioProductoRepository.findBySedeIdAndProductoId(sedeDestinoId, item.getProductoId()).orElseGet(() -> {
                    InventarioProducto nuevo = new InventarioProducto();
                    nuevo.setTiendaId(tiendaId);
                    nuevo.setSedeId(sedeDestinoId);
                    nuevo.setProductoId(item.getProductoId());
                    nuevo.setCantidadActual(Integer.valueOf(0));
                    return (InventarioProducto)this.inventarioProductoRepository.save((Object)nuevo);
                });
                anterior = inventario.getCantidadActual();
                posterior = (Integer)anterior + (Integer)cantidad;
                inventario.setCantidadActual(posterior);
                this.inventarioProductoRepository.save((Object)inventario);
                this.registrarMovimientoProducto(tiendaId, sedeDestinoId, item.getProductoId(), TipoMovimientoInsumo.ENTRADA, (Integer)cantidad, (Integer)anterior, posterior);
            }
            if (item.getInsumoId() == null) continue;
            cantidad = cantidadRecibida;
            if (cantidad == null || ((BigDecimal)cantidad).compareTo(BigDecimal.ZERO) <= 0) {
                throw new BadRequestException("La cantidad recibida del insumo es inv\u00e1lida");
            }
            inventario = this.inventarioInsumoSedeRepository.findBySedeIdAndInsumoId(sedeDestinoId, item.getInsumoId()).orElseGet(() -> {
                InventarioInsumoSede nuevo = new InventarioInsumoSede();
                nuevo.setTiendaId(tiendaId);
                nuevo.setSedeId(sedeDestinoId);
                nuevo.setInsumoId(item.getInsumoId());
                nuevo.setCantidadActual(BigDecimal.ZERO);
                return (InventarioInsumoSede)this.inventarioInsumoSedeRepository.save((Object)nuevo);
            });
            anterior = inventario.getCantidadActual();
            posterior = ((BigDecimal)anterior).add((BigDecimal)cantidad);
            inventario.setCantidadActual((BigDecimal)posterior);
            this.inventarioInsumoSedeRepository.save((Object)inventario);
            this.registrarMovimientoInsumo(tiendaId, sedeDestinoId, item.getInsumoId(), TipoMovimientoInsumo.ENTRADA, (BigDecimal)cantidad, (BigDecimal)anterior, (BigDecimal)posterior, transferencia.getId(), "Transferencia #" + transferencia.getId() + " (entrada)");
        }
    }

    private void aplicarEntradaDestinoIncremental(Long tiendaId, TransferenciaInventario transferencia, ItemTransferencia item, BigDecimal cantidadRecibidaAhora) {
        if (cantidadRecibidaAhora == null || cantidadRecibidaAhora.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Long sedeDestinoId = transferencia.getSedeDestinoId();
        if (item.getProductoId() != null) {
            Integer cantidad = this.convertirCantidadProducto(cantidadRecibidaAhora);
            InventarioProducto inventario = this.inventarioProductoRepository.findBySedeIdAndProductoId(sedeDestinoId, item.getProductoId()).orElseGet(() -> {
                InventarioProducto nuevo = new InventarioProducto();
                nuevo.setTiendaId(tiendaId);
                nuevo.setSedeId(sedeDestinoId);
                nuevo.setProductoId(item.getProductoId());
                nuevo.setCantidadActual(Integer.valueOf(0));
                return (InventarioProducto)this.inventarioProductoRepository.save((Object)nuevo);
            });
            Integer anterior = inventario.getCantidadActual();
            Integer posterior = anterior + cantidad;
            inventario.setCantidadActual(posterior);
            this.inventarioProductoRepository.save((Object)inventario);
            this.registrarMovimientoProducto(tiendaId, sedeDestinoId, item.getProductoId(), TipoMovimientoInsumo.ENTRADA, cantidad, anterior, posterior);
        }
        if (item.getInsumoId() != null) {
            InventarioInsumoSede inventario = this.inventarioInsumoSedeRepository.findBySedeIdAndInsumoId(sedeDestinoId, item.getInsumoId()).orElseGet(() -> {
                InventarioInsumoSede nuevo = new InventarioInsumoSede();
                nuevo.setTiendaId(tiendaId);
                nuevo.setSedeId(sedeDestinoId);
                nuevo.setInsumoId(item.getInsumoId());
                nuevo.setCantidadActual(BigDecimal.ZERO);
                return (InventarioInsumoSede)this.inventarioInsumoSedeRepository.save((Object)nuevo);
            });
            BigDecimal anterior = inventario.getCantidadActual();
            BigDecimal posterior = anterior.add(cantidadRecibidaAhora);
            inventario.setCantidadActual(posterior);
            this.inventarioInsumoSedeRepository.save((Object)inventario);
            this.registrarMovimientoInsumo(tiendaId, sedeDestinoId, item.getInsumoId(), TipoMovimientoInsumo.ENTRADA, cantidadRecibidaAhora, anterior, posterior, transferencia.getId(), "Transferencia #" + transferencia.getId() + " (entrada parcial)");
        }
    }

    private void revertirSalidaOrigen(Long tiendaId, TransferenciaInventario transferencia, List<ItemTransferencia> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        Long sedeOrigenId = transferencia.getSedeOrigenId();
        for (ItemTransferencia item : items) {
            Number posterior;
            Number anterior;
            InventarioProducto inventario;
            Number cantidad;
            if (item.getProductoId() != null) {
                cantidad = this.convertirCantidadProducto(item.getCantidadEnviada());
                inventario = this.inventarioProductoRepository.findBySedeIdAndProductoId(sedeOrigenId, item.getProductoId()).orElseGet(() -> {
                    InventarioProducto nuevo = new InventarioProducto();
                    nuevo.setTiendaId(tiendaId);
                    nuevo.setSedeId(sedeOrigenId);
                    nuevo.setProductoId(item.getProductoId());
                    nuevo.setCantidadActual(Integer.valueOf(0));
                    return (InventarioProducto)this.inventarioProductoRepository.save((Object)nuevo);
                });
                anterior = inventario.getCantidadActual();
                posterior = (Integer)anterior + (Integer)cantidad;
                inventario.setCantidadActual(posterior);
                this.inventarioProductoRepository.save((Object)inventario);
                this.registrarMovimientoProducto(tiendaId, sedeOrigenId, item.getProductoId(), TipoMovimientoInsumo.ENTRADA, (Integer)cantidad, (Integer)anterior, posterior);
            }
            if (item.getInsumoId() == null) continue;
            cantidad = item.getCantidadEnviada();
            if (cantidad == null || ((BigDecimal)cantidad).compareTo(BigDecimal.ZERO) <= 0) {
                throw new BadRequestException("La cantidad enviada del insumo es inv\u00e1lida");
            }
            inventario = this.inventarioInsumoSedeRepository.findBySedeIdAndInsumoId(sedeOrigenId, item.getInsumoId()).orElseGet(() -> {
                InventarioInsumoSede nuevo = new InventarioInsumoSede();
                nuevo.setTiendaId(tiendaId);
                nuevo.setSedeId(sedeOrigenId);
                nuevo.setInsumoId(item.getInsumoId());
                nuevo.setCantidadActual(BigDecimal.ZERO);
                return (InventarioInsumoSede)this.inventarioInsumoSedeRepository.save((Object)nuevo);
            });
            anterior = inventario.getCantidadActual();
            posterior = ((BigDecimal)anterior).add((BigDecimal)cantidad);
            inventario.setCantidadActual((BigDecimal)posterior);
            this.inventarioInsumoSedeRepository.save((Object)inventario);
            this.registrarMovimientoInsumo(tiendaId, sedeOrigenId, item.getInsumoId(), TipoMovimientoInsumo.ENTRADA, (BigDecimal)cantidad, (BigDecimal)anterior, (BigDecimal)posterior, transferencia.getId(), "Transferencia #" + transferencia.getId() + " (reverso cancelaci\u00f3n)");
        }
    }

    private Integer convertirCantidadProducto(BigDecimal cantidad) {
        if (cantidad == null) {
            throw new BadRequestException("La cantidad del producto es requerida");
        }
        if (cantidad.compareTo(BigDecimal.ZERO) <= 0) {
            throw new BadRequestException("La cantidad del producto debe ser mayor a 0");
        }
        BigDecimal normalizada = cantidad.stripTrailingZeros();
        if (normalizada.scale() > 0) {
            throw new BadRequestException("La cantidad del producto debe ser un entero (sin decimales)");
        }
        try {
            return normalizada.intValueExact();
        }
        catch (ArithmeticException ex) {
            throw new BadRequestException("La cantidad del producto est\u00e1 fuera de rango");
        }
    }

    private void registrarMovimientoProducto(Long tiendaId, Long sedeId, Long productoId, TipoMovimientoInsumo tipo, Integer cantidad, Integer anterior, Integer posterior) {
        MovimientoInventarioProducto movimiento = new MovimientoInventarioProducto();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(sedeId);
        movimiento.setProductoId(productoId);
        movimiento.setTipoMovimiento(tipo);
        movimiento.setCantidad(cantidad);
        movimiento.setCantidadAnterior(anterior);
        movimiento.setCantidadPosterior(posterior);
        movimiento.setMotivo(MotivoMovimientoProducto.TRANSFERENCIA);
        this.movimientoInventarioProductoRepository.save((Object)movimiento);
    }

    private void registrarMovimientoInsumo(Long tiendaId, Long sedeId, Long insumoId, TipoMovimientoInsumo tipo, BigDecimal cantidad, BigDecimal anterior, BigDecimal posterior, Long transferenciaId, String motivo) {
        MovimientoInventarioInsumo movimiento = new MovimientoInventarioInsumo();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(sedeId);
        movimiento.setInsumoId(insumoId);
        movimiento.setTipoMovimiento(tipo);
        movimiento.setCantidad(cantidad);
        movimiento.setCantidadAnterior(anterior);
        movimiento.setCantidadPosterior(posterior);
        movimiento.setTransferenciaId(transferenciaId);
        movimiento.setMotivo(motivo);
        this.movimientoInventarioInsumoRepository.save((Object)movimiento);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long id) {
        TransferenciaInventario transferencia = (TransferenciaInventario)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Transferencia no encontrada"));
        this.repository.delete((Object)transferencia);
    }

    @Transactional
    public TransferenciaInventarioResponse recibir(Long tiendaId, Long id, TransferenciaRecepcionRequest request) {
        boolean todosCompletados;
        TransferenciaInventario transferencia = (TransferenciaInventario)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Transferencia no encontrada"));
        if (transferencia.getEstado() != EstadoTransferencia.EN_TRANSITO) {
            throw new BadRequestException("Solo se pueden recibir transferencias en estado EN_TRANSITO");
        }
        if (request == null || request.getItems() == null || request.getItems().isEmpty()) {
            throw new BadRequestException("Debe incluir al menos un item para recibir");
        }
        List items = this.itemRepository.findByTransferenciaId(id);
        HashMap<Long, ItemTransferencia> itemsById = new HashMap<Long, ItemTransferencia>();
        for (ItemTransferencia it : items) {
            if (it.getId() == null) continue;
            itemsById.put(it.getId(), it);
        }
        for (ItemTransferenciaRecepcionRequest itemReq : request.getItems()) {
            BigDecimal normalized;
            ItemTransferencia item2 = (ItemTransferencia)itemsById.get(itemReq.getItemId());
            if (item2 == null) {
                throw new BadRequestException("El itemId " + itemReq.getItemId() + " no pertenece a la transferencia");
            }
            BigDecimal recibidaAhora = itemReq.getCantidadRecibida();
            if (recibidaAhora == null || recibidaAhora.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BadRequestException("La cantidad recibida debe ser mayor a 0");
            }
            BigDecimal recibidaAnterior = item2.getCantidadRecibida() != null ? item2.getCantidadRecibida() : BigDecimal.ZERO;
            BigDecimal totalRecibido = recibidaAnterior.add(recibidaAhora);
            if (item2.getCantidadEnviada() != null && totalRecibido.compareTo(item2.getCantidadEnviada()) > 0) {
                throw new BadRequestException(String.format("La cantidad total recibida (%.2f) no puede superar la enviada (%.2f)", totalRecibido, item2.getCantidadEnviada()));
            }
            if (item2.getProductoId() != null && (normalized = recibidaAhora.stripTrailingZeros()).scale() > 0) {
                throw new BadRequestException("Para productos, la cantidad recibida debe ser un entero");
            }
            this.aplicarEntradaDestinoIncremental(tiendaId, transferencia, item2, recibidaAhora);
            item2.setCantidadRecibida(totalRecibido);
            this.itemRepository.save((Object)item2);
        }
        if (request.getRecibidoPor() != null) {
            transferencia.setRecibidoPor(request.getRecibidoPor());
        }
        if (todosCompletados = items.stream().allMatch(item -> {
            BigDecimal recibida = item.getCantidadRecibida();
            BigDecimal enviada = item.getCantidadEnviada();
            return recibida != null && enviada != null && recibida.compareTo(enviada) >= 0;
        })) {
            transferencia.setEstado(EstadoTransferencia.RECIBIDO);
            transferencia.setFechaRecepcion(LocalDateTime.now());
        }
        TransferenciaInventario actualizado = (TransferenciaInventario)this.repository.save((Object)transferencia);
        return this.toResponse(actualizado);
    }

    private void validarTransicionEstado(EstadoTransferencia estadoActual, EstadoTransferencia nuevoEstado) {
        boolean transicionValida = false;
        switch (1.$SwitchMap$com$dulcecontrol$bakery$features$admin$inventario$entity$enums$EstadoTransferencia[estadoActual.ordinal()]) {
            case 1: {
                transicionValida = nuevoEstado == EstadoTransferencia.EN_TRANSITO || nuevoEstado == EstadoTransferencia.CANCELADO;
                break;
            }
            case 2: {
                transicionValida = nuevoEstado == EstadoTransferencia.RECIBIDO || nuevoEstado == EstadoTransferencia.CANCELADO;
                break;
            }
            case 3: 
            case 4: {
                transicionValida = false;
            }
        }
        if (!transicionValida) {
            throw new BadRequestException(String.format("No se puede cambiar de estado %s a %s", estadoActual, nuevoEstado));
        }
    }

    private TransferenciaInventarioResponse toResponse(TransferenciaInventario entity) {
        List<ItemTransferenciaResponse> items = this.itemRepository.findByTransferenciaId(entity.getId()).stream().map(arg_0 -> this.itemToResponse(arg_0)).toList();
        return TransferenciaInventarioResponse.builder().id(entity.getId()).sedeOrigenId(entity.getSedeOrigenId()).sedeDestinoId(entity.getSedeDestinoId()).estado(entity.getEstado()).solicitadoPor(entity.getSolicitadoPor()).autorizadoPor(entity.getAutorizadoPor()).recibidoPor(entity.getRecibidoPor()).fechaSolicitud(entity.getFechaSolicitud()).fechaEnvio(entity.getFechaEnvio()).fechaRecepcion(entity.getFechaRecepcion()).observaciones(entity.getObservaciones()).items(items).build();
    }

    private ItemTransferenciaResponse itemToResponse(ItemTransferencia entity) {
        return ItemTransferenciaResponse.builder().id(entity.getId()).transferenciaId(entity.getTransferenciaId()).insumoId(entity.getInsumoId()).productoId(entity.getProductoId()).cantidadEnviada(entity.getCantidadEnviada()).cantidadRecibida(entity.getCantidadRecibida()).build();
    }

    @Generated
    public TransferenciaInventarioService(TransferenciaInventarioRepository repository, ItemTransferenciaRepository itemRepository, InventarioProductoRepository inventarioProductoRepository, InventarioInsumoSedeRepository inventarioInsumoSedeRepository, MovimientoInventarioProductoRepository movimientoInventarioProductoRepository, MovimientoInventarioInsumoRepository movimientoInventarioInsumoRepository) {
        this.repository = repository;
        this.itemRepository = itemRepository;
        this.inventarioProductoRepository = inventarioProductoRepository;
        this.inventarioInsumoSedeRepository = inventarioInsumoSedeRepository;
        this.movimientoInventarioProductoRepository = movimientoInventarioProductoRepository;
        this.movimientoInventarioInsumoRepository = movimientoInventarioInsumoRepository;
    }
}

