/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.service.impl;

import com.dulcecontrol.bakery.features.admin.compras.entity.Insumo;
import com.dulcecontrol.bakery.features.admin.compras.repository.InsumoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.dto.MovimientoInventarioInsumoCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.MovimientoInventarioInsumoResponse;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioInsumoSede;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioInsumoSedeRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioInsumoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.service.IMovimientoInventarioInsumoService;
import com.dulcecontrol.bakery.features.admin.inventario.service.impl.MovimientoInventarioInsumoService;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioTienda;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MovimientoInventarioInsumoService
implements IMovimientoInventarioInsumoService {
    private final MovimientoInventarioInsumoRepository repository;
    private final InventarioInsumoSedeRepository inventarioRepository;
    private final InsumoRepository insumoRepository;
    private final UsuarioTiendaRepository usuarioRepository;

    @Transactional(readOnly=true)
    public List<MovimientoInventarioInsumoResponse> listarPorTienda(Long tiendaId) {
        return this.repository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<MovimientoInventarioInsumoResponse> listarPorTiendaYSede(Long tiendaId, Long sedeId) {
        return this.repository.findByTiendaIdAndSedeId(tiendaId, sedeId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public Page<MovimientoInventarioInsumoResponse> listarPorTiendaYSedePaginado(Long tiendaId, Long sedeId, Pageable pageable) {
        return this.repository.findByTiendaIdAndSedeIdOrderByCreadoEnDesc(tiendaId, sedeId, pageable).map(arg_0 -> this.toResponse(arg_0));
    }

    @Transactional(readOnly=true)
    public MovimientoInventarioInsumoResponse obtenerPorId(Long tiendaId, Long id) {
        MovimientoInventarioInsumo movimiento = (MovimientoInventarioInsumo)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Movimiento de inventario no encontrado"));
        return this.toResponse(movimiento);
    }

    @Transactional
    public MovimientoInventarioInsumoResponse crear(Long tiendaId, MovimientoInventarioInsumoCreateRequest request) {
        BigDecimal nuevaCantidad;
        InventarioInsumoSede inventario = this.inventarioRepository.findBySedeIdAndInsumoId(request.getSedeId(), request.getInsumoId()).orElseGet(() -> {
            InventarioInsumoSede nuevo = new InventarioInsumoSede();
            nuevo.setTiendaId(tiendaId);
            nuevo.setSedeId(request.getSedeId());
            nuevo.setInsumoId(request.getInsumoId());
            nuevo.setCantidadActual(BigDecimal.ZERO);
            return (InventarioInsumoSede)this.inventarioRepository.save((Object)nuevo);
        });
        BigDecimal cantidadAnterior = inventario.getCantidadActual();
        switch (1.$SwitchMap$com$dulcecontrol$bakery$features$admin$inventario$entity$enums$TipoMovimientoInsumo[request.getTipoMovimiento().ordinal()]) {
            case 1: {
                nuevaCantidad = cantidadAnterior.add(request.getCantidad());
                break;
            }
            case 2: {
                nuevaCantidad = cantidadAnterior.subtract(request.getCantidad());
                if (nuevaCantidad.compareTo(BigDecimal.ZERO) >= 0) break;
                throw new BadRequestException("No hay suficiente stock. Stock actual: " + String.valueOf(cantidadAnterior));
            }
            case 3: {
                nuevaCantidad = request.getCantidad();
                break;
            }
            case 4: {
                if (request.getCantidad().compareTo(BigDecimal.ZERO) > 0) {
                    nuevaCantidad = cantidadAnterior.add(request.getCantidad());
                    break;
                }
                nuevaCantidad = cantidadAnterior.add(request.getCantidad());
                if (nuevaCantidad.compareTo(BigDecimal.ZERO) >= 0) break;
                throw new BadRequestException("No hay suficiente stock para la transferencia. Stock actual: " + String.valueOf(cantidadAnterior));
            }
            default: {
                throw new BadRequestException("Tipo de movimiento no v\u00e1lido");
            }
        }
        inventario.setCantidadActual(nuevaCantidad);
        this.inventarioRepository.save((Object)inventario);
        MovimientoInventarioInsumo movimiento = new MovimientoInventarioInsumo();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(request.getSedeId());
        movimiento.setInsumoId(request.getInsumoId());
        movimiento.setTipoMovimiento(request.getTipoMovimiento());
        movimiento.setCantidad(request.getCantidad());
        movimiento.setCantidadAnterior(cantidadAnterior);
        movimiento.setCantidadPosterior(nuevaCantidad);
        movimiento.setOrdenCompraId(request.getOrdenCompraId());
        movimiento.setPlanProduccionId(request.getPlanProduccionId());
        movimiento.setTransferenciaId(request.getTransferenciaId());
        movimiento.setMotivo(request.getMotivo());
        movimiento.setResponsableId(request.getResponsableId());
        MovimientoInventarioInsumo guardado = (MovimientoInventarioInsumo)this.repository.save((Object)movimiento);
        return this.toResponse(guardado);
    }

    @Transactional(readOnly=true)
    public List<MovimientoInventarioInsumoResponse> listarPorInsumo(Long tiendaId, Long sedeId, Long insumoId) {
        return this.repository.findByTiendaIdAndSedeIdAndInsumoId(tiendaId, sedeId, insumoId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<MovimientoInventarioInsumoResponse> listarPorRangoFechas(Long tiendaId, LocalDateTime inicio, LocalDateTime fin) {
        if (inicio == null || fin == null) {
            return this.listarPorTienda(tiendaId);
        }
        return this.repository.findByTiendaIdAndCreadoEnBetween(tiendaId, inicio, fin).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    private MovimientoInventarioInsumoResponse toResponse(MovimientoInventarioInsumo entity) {
        Insumo insumo = this.insumoRepository.findById((Object)entity.getInsumoId()).orElse(null);
        String usuarioResponsable = null;
        if (entity.getResponsableId() != null) {
            usuarioResponsable = this.usuarioRepository.findById((Object)entity.getResponsableId()).map(UsuarioTienda::getNombres).orElse(null);
        }
        return MovimientoInventarioInsumoResponse.builder().id(entity.getId()).sedeId(entity.getSedeId()).insumoId(entity.getInsumoId()).nombreInsumo(insumo != null ? insumo.getNombre() : null).codigoInterno(insumo != null ? insumo.getCodigoInterno() : null).unidadMedida(insumo != null && insumo.getUnidadBase() != null ? insumo.getUnidadBase().name() : null).tipoMovimiento(entity.getTipoMovimiento()).cantidad(entity.getCantidad()).cantidadAnterior(entity.getCantidadAnterior()).cantidadPosterior(entity.getCantidadPosterior()).ordenCompraId(entity.getOrdenCompraId()).planProduccionId(entity.getPlanProduccionId()).transferenciaId(entity.getTransferenciaId()).motivo(entity.getMotivo()).responsableId(entity.getResponsableId()).usuarioResponsable(usuarioResponsable).creadoEn(entity.getCreadoEn()).build();
    }

    @Generated
    public MovimientoInventarioInsumoService(MovimientoInventarioInsumoRepository repository, InventarioInsumoSedeRepository inventarioRepository, InsumoRepository insumoRepository, UsuarioTiendaRepository usuarioRepository) {
        this.repository = repository;
        this.inventarioRepository = inventarioRepository;
        this.insumoRepository = insumoRepository;
        this.usuarioRepository = usuarioRepository;
    }
}

