/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.service.impl;

import com.dulcecontrol.bakery.features.admin.compras.entity.Insumo;
import com.dulcecontrol.bakery.features.admin.compras.repository.InsumoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioInsumoSedeCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioInsumoSedeResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioInsumoSedeUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.UbicacionFisicaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioInsumoSede;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioInsumoSedeRepository;
import com.dulcecontrol.bakery.features.admin.inventario.service.IInventarioInsumoSedeService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventarioInsumoSedeService
implements IInventarioInsumoSedeService {
    private final InventarioInsumoSedeRepository repository;
    private final InsumoRepository insumoRepository;

    @Transactional(readOnly=true)
    public List<InventarioInsumoSedeResponse> listarPorTienda(Long tiendaId) {
        return this.repository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<InventarioInsumoSedeResponse> listarPorTiendaYSede(Long tiendaId, Long sedeId) {
        return this.repository.findEnrichedByTiendaIdAndSedeId(tiendaId, sedeId).stream().map(arg_0 -> this.toResponseEnriquecido(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public InventarioInsumoSedeResponse obtenerPorId(Long tiendaId, Long id) {
        InventarioInsumoSede inventario = (InventarioInsumoSede)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de insumo no encontrado"));
        return this.toResponse(inventario);
    }

    @Transactional
    public InventarioInsumoSedeResponse crear(Long tiendaId, InventarioInsumoSedeCreateRequest request) {
        if (this.repository.existsBySedeIdAndInsumoId(request.getSedeId(), request.getInsumoId())) {
            throw new BadRequestException("Ya existe un inventario para este insumo en la sede");
        }
        InventarioInsumoSede inventario = new InventarioInsumoSede();
        inventario.setTiendaId(tiendaId);
        inventario.setSedeId(request.getSedeId());
        inventario.setInsumoId(request.getInsumoId());
        inventario.setCantidadActual(request.getCantidadActual() != null ? request.getCantidadActual() : BigDecimal.ZERO);
        inventario.setUbicacionFisica(request.getUbicacionFisica());
        InventarioInsumoSede guardado = (InventarioInsumoSede)this.repository.save((Object)inventario);
        return this.toResponse(guardado);
    }

    @Transactional
    public InventarioInsumoSedeResponse actualizar(Long tiendaId, Long id, InventarioInsumoSedeUpdateRequest request) {
        InventarioInsumoSede inventario = (InventarioInsumoSede)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de insumo no encontrado"));
        inventario.setCantidadActual(request.getCantidadActual());
        inventario.setUbicacionFisica(request.getUbicacionFisica());
        InventarioInsumoSede actualizado = (InventarioInsumoSede)this.repository.save((Object)inventario);
        return this.toResponse(actualizado);
    }

    @Transactional
    public InventarioInsumoSedeResponse actualizarUbicacion(Long tiendaId, Long id, UbicacionFisicaUpdateRequest request) {
        String ubicacion;
        InventarioInsumoSede inventario = (InventarioInsumoSede)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de insumo no encontrado"));
        String string = ubicacion = request != null ? request.getUbicacionFisica() : null;
        if (ubicacion != null && (ubicacion = ubicacion.trim()).isBlank()) {
            ubicacion = null;
        }
        inventario.setUbicacionFisica(ubicacion);
        InventarioInsumoSede actualizado = (InventarioInsumoSede)this.repository.save((Object)inventario);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long id) {
        InventarioInsumoSede inventario = (InventarioInsumoSede)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de insumo no encontrado"));
        this.repository.delete((Object)inventario);
    }

    @Transactional(readOnly=true)
    public List<InventarioInsumoSedeResponse> listarBajoStock(Long tiendaId, Long sedeId, BigDecimal cantidadMinima) {
        return this.repository.findBajoStock(tiendaId, sedeId, cantidadMinima).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    private InventarioInsumoSedeResponse toResponse(InventarioInsumoSede entity) {
        return InventarioInsumoSedeResponse.builder().id(entity.getId()).sedeId(entity.getSedeId()).insumoId(entity.getInsumoId()).cantidadActual(entity.getCantidadActual()).ubicacionFisica(entity.getUbicacionFisica()).actualizadoEn(entity.getActualizadoEn()).build();
    }

    private InventarioInsumoSedeResponse toResponseEnriquecido(InventarioInsumoSede entity) {
        Insumo insumo = (Insumo)this.insumoRepository.findById((Object)entity.getInsumoId()).orElseThrow(() -> new ResourceNotFoundException("Insumo no encontrado"));
        String estadoStock = this.calcularEstadoStock(entity.getCantidadActual(), insumo.getStockMinimoGlobal());
        return InventarioInsumoSedeResponse.builder().id(entity.getId()).sedeId(entity.getSedeId()).insumoId(entity.getInsumoId()).nombreInsumo(insumo.getNombre()).codigoInterno(insumo.getCodigoInterno()).unidadMedida(insumo.getUnidadBase() != null ? insumo.getUnidadBase().name() : "UNIDAD").stockMinimo(insumo.getStockMinimoGlobal()).activo(insumo.getActivo()).cantidadActual(entity.getCantidadActual()).estadoStock(estadoStock).ubicacionFisica(entity.getUbicacionFisica()).actualizadoEn(entity.getActualizadoEn()).build();
    }

    private String calcularEstadoStock(BigDecimal cantidadActual, BigDecimal stockMinimo) {
        if (stockMinimo == null || stockMinimo.compareTo(BigDecimal.ZERO) == 0) {
            return "SIN_CONFIGURAR";
        }
        BigDecimal porcentaje = cantidadActual.divide(stockMinimo, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
        if (porcentaje.compareTo(BigDecimal.valueOf(80L)) >= 0) {
            return "OK";
        }
        if (porcentaje.compareTo(BigDecimal.valueOf(20L)) >= 0) {
            return "BAJO_STOCK";
        }
        return "CRITICO";
    }

    @Generated
    public InventarioInsumoSedeService(InventarioInsumoSedeRepository repository, InsumoRepository insumoRepository) {
        this.repository = repository;
        this.insumoRepository = insumoRepository;
    }
}

