/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.controller;

import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaInventarioCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaInventarioResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaInventarioUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.TransferenciaRecepcionRequest;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.EstadoTransferencia;
import com.dulcecontrol.bakery.features.admin.inventario.service.ITransferenciaInventarioService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/inventario/transferencias"})
@Validated
public class TransferenciaInventarioController {
    private final ITransferenciaInventarioService service;

    @GetMapping
    public ResponseEntity<List<TransferenciaInventarioResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.service.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/estado/{estado}"})
    public ResponseEntity<List<TransferenciaInventarioResponse>> listarPorEstado(@PathVariable Long tiendaId, @PathVariable EstadoTransferencia estado) {
        return ResponseEntity.ok((Object)this.service.listarPorEstado(tiendaId, estado));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TransferenciaInventarioResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.obtenerPorId(tiendaId, id));
    }

    @PostMapping
    public ResponseEntity<TransferenciaInventarioResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody TransferenciaInventarioCreateRequest request) {
        TransferenciaInventarioResponse creado = this.service.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)creado);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<TransferenciaInventarioResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long id, @Valid @RequestBody TransferenciaInventarioUpdateRequest request) {
        TransferenciaInventarioResponse actualizado = this.service.actualizar(tiendaId, id, request);
        return ResponseEntity.ok((Object)actualizado);
    }

    @PatchMapping(value={"/{id}/estado"})
    public ResponseEntity<TransferenciaInventarioResponse> cambiarEstado(@PathVariable Long tiendaId, @PathVariable Long id, @RequestParam EstadoTransferencia nuevoEstado) {
        TransferenciaInventarioResponse actualizado = this.service.cambiarEstado(tiendaId, id, nuevoEstado);
        return ResponseEntity.ok((Object)actualizado);
    }

    @PatchMapping(value={"/{id}/recibir"})
    public ResponseEntity<TransferenciaInventarioResponse> recibir(@PathVariable Long tiendaId, @PathVariable Long id, @Valid @RequestBody TransferenciaRecepcionRequest request) {
        TransferenciaInventarioResponse actualizado = this.service.recibir(tiendaId, id, request);
        return ResponseEntity.ok((Object)actualizado);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long id) {
        this.service.eliminar(tiendaId, id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public TransferenciaInventarioController(ITransferenciaInventarioService service) {
        this.service = service;
    }
}

