/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.controller;

import com.dulcecontrol.bakery.features.admin.inventario.dto.MovimientoInventarioInsumoCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.MovimientoInventarioInsumoResponse;
import com.dulcecontrol.bakery.features.admin.inventario.service.IMovimientoInventarioInsumoService;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/inventario/movimientos/insumos"})
@Validated
public class MovimientoInventarioInsumoController {
    private final IMovimientoInventarioInsumoService service;

    @GetMapping
    public ResponseEntity<List<MovimientoInventarioInsumoResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.service.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/sede/{sedeId}"})
    public ResponseEntity<List<MovimientoInventarioInsumoResponse>> listarPorSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        return ResponseEntity.ok((Object)this.service.listarPorTiendaYSede(tiendaId, sedeId));
    }

    @GetMapping(value={"/sede/{sedeId}/paginado"})
    public ResponseEntity<Page<MovimientoInventarioInsumoResponse>> listarPorSedePaginado(@PathVariable Long tiendaId, @PathVariable Long sedeId, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.listarPorTiendaYSedePaginado(tiendaId, sedeId, pageable));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<MovimientoInventarioInsumoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.obtenerPorId(tiendaId, id));
    }

    @GetMapping(value={"/sede/{sedeId}/insumo/{insumoId}"})
    public ResponseEntity<List<MovimientoInventarioInsumoResponse>> listarPorInsumo(@PathVariable Long tiendaId, @PathVariable Long sedeId, @PathVariable Long insumoId) {
        return ResponseEntity.ok((Object)this.service.listarPorInsumo(tiendaId, sedeId, insumoId));
    }

    @GetMapping(value={"/rango-fechas"})
    public ResponseEntity<List<MovimientoInventarioInsumoResponse>> listarPorRangoFechas(@PathVariable Long tiendaId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime inicio, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fin) {
        return ResponseEntity.ok((Object)this.service.listarPorRangoFechas(tiendaId, inicio, fin));
    }

    @PostMapping
    public ResponseEntity<MovimientoInventarioInsumoResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody MovimientoInventarioInsumoCreateRequest request) {
        MovimientoInventarioInsumoResponse creado = this.service.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)creado);
    }

    @Generated
    public MovimientoInventarioInsumoController(IMovimientoInventarioInsumoService service) {
        this.service = service;
    }
}

