/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.controller;

import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.UbicacionFisicaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.service.IInventarioProductoService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/inventario/productos"})
@Validated
public class InventarioProductoController {
    private final IInventarioProductoService service;

    @GetMapping
    public ResponseEntity<List<InventarioProductoResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.service.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/sede/{sedeId}"})
    public ResponseEntity<List<InventarioProductoResponse>> listarPorSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        return ResponseEntity.ok((Object)this.service.listarPorTiendaYSede(tiendaId, sedeId));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<InventarioProductoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.obtenerPorId(tiendaId, id));
    }

    @GetMapping(value={"/sede/{sedeId}/bajo-stock"})
    public ResponseEntity<List<InventarioProductoResponse>> listarBajoStock(@PathVariable Long tiendaId, @PathVariable Long sedeId, @RequestParam(defaultValue="5") Integer cantidadMinima) {
        return ResponseEntity.ok((Object)this.service.listarBajoStock(tiendaId, sedeId, cantidadMinima));
    }

    @PostMapping
    public ResponseEntity<InventarioProductoResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody InventarioProductoCreateRequest request) {
        InventarioProductoResponse creado = this.service.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)creado);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<InventarioProductoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long id, @Valid @RequestBody InventarioProductoUpdateRequest request) {
        InventarioProductoResponse actualizado = this.service.actualizar(tiendaId, id, request);
        return ResponseEntity.ok((Object)actualizado);
    }

    @PatchMapping(value={"/{id}/ubicacion"})
    public ResponseEntity<InventarioProductoResponse> actualizarUbicacion(@PathVariable Long tiendaId, @PathVariable Long id, @Valid @RequestBody UbicacionFisicaUpdateRequest request) {
        InventarioProductoResponse actualizado = this.service.actualizarUbicacion(tiendaId, id, request);
        return ResponseEntity.ok((Object)actualizado);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long id) {
        this.service.eliminar(tiendaId, id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public InventarioProductoController(IInventarioProductoService service) {
        this.service = service;
    }
}

