/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.facturacion.service;

import com.dulcecontrol.bakery.features.admin.facturacion.dto.TiendaSerieRequest;
import com.dulcecontrol.bakery.features.admin.facturacion.dto.TiendaSerieResponse;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.TiendaSerie;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.TipoComprobante;
import com.dulcecontrol.bakery.features.admin.facturacion.repository.TiendaSerieRepository;
import com.dulcecontrol.bakery.features.admin.facturacion.service.TiendaSerieService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TiendaSerieServiceImpl
implements TiendaSerieService {
    private final TiendaSerieRepository tiendaSerieRepository;

    @Transactional
    public TiendaSerieResponse crear(Long tiendaId, TiendaSerieRequest request) {
        if (!tiendaId.equals(request.getTiendaId())) {
            throw new IllegalArgumentException("El tiendaId de la URL no coincide con el tiendaId del request");
        }
        if (this.tiendaSerieRepository.existsByTiendaIdAndSerieAndActivaTrue(tiendaId, request.getSerie())) {
            throw new IllegalArgumentException("Ya existe una serie activa con el c\u00f3digo: " + request.getSerie());
        }
        TiendaSerie serie = new TiendaSerie();
        serie.setTiendaId(tiendaId);
        serie.setSedeId(request.getSedeId());
        serie.setTipoComprobante(request.getTipoComprobante());
        serie.setSerie(request.getSerie());
        serie.setCorrelativoActual(Integer.valueOf(request.getCorrelativoActual() != null ? request.getCorrelativoActual() : 0));
        serie.setEsElectronica(request.getEsElectronica() != null ? request.getEsElectronica() : Boolean.TRUE);
        serie.setActiva(request.getActiva() != null ? request.getActiva() : Boolean.TRUE);
        TiendaSerie saved = (TiendaSerie)this.tiendaSerieRepository.save((Object)serie);
        return this.mapToResponse(saved);
    }

    @Transactional(readOnly=true)
    public TiendaSerieResponse obtenerPorIdYTienda(Long serieId, Long tiendaId) {
        TiendaSerie serie = (TiendaSerie)this.tiendaSerieRepository.findByIdAndTiendaId(serieId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Serie no encontrada con id: " + serieId));
        return this.mapToResponse(serie);
    }

    @Transactional(readOnly=true)
    public List<TiendaSerieResponse> listarPorTienda(Long tiendaId) {
        return this.tiendaSerieRepository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<TiendaSerieResponse> listarPorTiendaYSede(Long tiendaId, Long sedeId) {
        return this.tiendaSerieRepository.findByTiendaIdAndSedeId(tiendaId, sedeId).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<TiendaSerieResponse> listarActivasPorTienda(Long tiendaId) {
        return this.tiendaSerieRepository.findByTiendaIdAndActivaTrue(tiendaId).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<TiendaSerieResponse> listarActivasPorTiendaYTipo(Long tiendaId, TipoComprobante tipoComprobante) {
        return this.tiendaSerieRepository.findByTiendaIdAndTipoComprobanteAndActivaTrue(tiendaId, tipoComprobante).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional
    public TiendaSerieResponse actualizar(Long tiendaId, Long serieId, TiendaSerieRequest request) {
        TiendaSerie serie = (TiendaSerie)this.tiendaSerieRepository.findByIdAndTiendaId(serieId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Serie no encontrada con id: " + serieId));
        if (!serie.getSerie().equals(request.getSerie()) && this.tiendaSerieRepository.existsByTiendaIdAndSerieAndActivaTrue(tiendaId, request.getSerie())) {
            throw new IllegalArgumentException("Ya existe una serie activa con el c\u00f3digo: " + request.getSerie());
        }
        serie.setSedeId(request.getSedeId());
        serie.setTipoComprobante(request.getTipoComprobante());
        serie.setSerie(request.getSerie());
        serie.setCorrelativoActual(request.getCorrelativoActual());
        serie.setEsElectronica(request.getEsElectronica());
        serie.setActiva(request.getActiva());
        TiendaSerie updated = (TiendaSerie)this.tiendaSerieRepository.save((Object)serie);
        return this.mapToResponse(updated);
    }

    @Transactional
    public void desactivar(Long tiendaId, Long serieId) {
        TiendaSerie serie = (TiendaSerie)this.tiendaSerieRepository.findByIdAndTiendaId(serieId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Serie no encontrada con id: " + serieId));
        serie.setActiva(Boolean.FALSE);
        this.tiendaSerieRepository.save((Object)serie);
    }

    @Transactional
    public void activar(Long tiendaId, Long serieId) {
        TiendaSerie serie = (TiendaSerie)this.tiendaSerieRepository.findByIdAndTiendaId(serieId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Serie no encontrada con id: " + serieId));
        if (this.tiendaSerieRepository.existsByTiendaIdAndSerieAndActivaTrue(tiendaId, serie.getSerie())) {
            throw new IllegalArgumentException("Ya existe una serie activa con el c\u00f3digo: " + serie.getSerie());
        }
        serie.setActiva(Boolean.TRUE);
        this.tiendaSerieRepository.save((Object)serie);
    }

    @Transactional
    public Integer incrementarCorrelativo(Long tiendaId, Long serieId) {
        TiendaSerie serie = (TiendaSerie)this.tiendaSerieRepository.findByIdAndTiendaId(serieId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Serie no encontrada con id: " + serieId));
        if (!serie.getActiva().booleanValue()) {
            throw new IllegalArgumentException("No se puede incrementar el correlativo de una serie inactiva");
        }
        Integer nuevoCorrelativo = serie.getCorrelativoActual() + 1;
        serie.setCorrelativoActual(nuevoCorrelativo);
        this.tiendaSerieRepository.save((Object)serie);
        return nuevoCorrelativo;
    }

    private TiendaSerieResponse mapToResponse(TiendaSerie serie) {
        TiendaSerieResponse response = new TiendaSerieResponse();
        response.setId(serie.getId());
        response.setTiendaId(serie.getTiendaId());
        response.setSedeId(serie.getSedeId());
        response.setTipoComprobante(serie.getTipoComprobante());
        response.setSerie(serie.getSerie());
        response.setCorrelativoActual(serie.getCorrelativoActual());
        response.setEsElectronica(serie.getEsElectronica());
        response.setActiva(serie.getActiva());
        response.setCreadoEn(serie.getCreadoEn());
        return response;
    }

    @Generated
    public TiendaSerieServiceImpl(TiendaSerieRepository tiendaSerieRepository) {
        this.tiendaSerieRepository = tiendaSerieRepository;
    }
}

