/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.facturacion.entity;

import com.dulcecontrol.bakery.features.admin.facturacion.entity.converter.TipoComprobanteConverter;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.TipoComprobante;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="tienda_series")
public class TiendaSerie {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="sede_id", nullable=false)
    private Long sedeId;
    @Convert(converter=TipoComprobanteConverter.class)
    @Column(name="tipo_comprobante", nullable=false, columnDefinition="ENUM('factura', 'boleta', 'nota_credito', 'nota_debito')")
    private TipoComprobante tipoComprobante;
    @Column(nullable=false, length=4)
    private String serie;
    @Column(name="correlativo_actual", nullable=false)
    private Integer correlativoActual = 0;
    @Column(name="es_electronica")
    private Boolean esElectronica = Boolean.TRUE;
    @Column(nullable=false)
    private Boolean activa = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        if (this.correlativoActual == null) {
            this.correlativoActual = 0;
        }
        if (this.esElectronica == null) {
            this.esElectronica = Boolean.TRUE;
        }
        if (this.activa == null) {
            this.activa = Boolean.TRUE;
        }
    }

    @Generated
    public TiendaSerie() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getSedeId() {
        return this.sedeId;
    }

    @Generated
    public TipoComprobante getTipoComprobante() {
        return this.tipoComprobante;
    }

    @Generated
    public String getSerie() {
        return this.serie;
    }

    @Generated
    public Integer getCorrelativoActual() {
        return this.correlativoActual;
    }

    @Generated
    public Boolean getEsElectronica() {
        return this.esElectronica;
    }

    @Generated
    public Boolean getActiva() {
        return this.activa;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setSedeId(Long sedeId) {
        this.sedeId = sedeId;
    }

    @Generated
    public void setTipoComprobante(TipoComprobante tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    @Generated
    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Generated
    public void setCorrelativoActual(Integer correlativoActual) {
        this.correlativoActual = correlativoActual;
    }

    @Generated
    public void setEsElectronica(Boolean esElectronica) {
        this.esElectronica = esElectronica;
    }

    @Generated
    public void setActiva(Boolean activa) {
        this.activa = activa;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TiendaSerie)) {
            return false;
        }
        TiendaSerie other = (TiendaSerie)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$sedeId = this.getSedeId();
        Long other$sedeId = other.getSedeId();
        if (this$sedeId == null ? other$sedeId != null : !((Object)this$sedeId).equals(other$sedeId)) {
            return false;
        }
        Integer this$correlativoActual = this.getCorrelativoActual();
        Integer other$correlativoActual = other.getCorrelativoActual();
        if (this$correlativoActual == null ? other$correlativoActual != null : !((Object)this$correlativoActual).equals(other$correlativoActual)) {
            return false;
        }
        Boolean this$esElectronica = this.getEsElectronica();
        Boolean other$esElectronica = other.getEsElectronica();
        if (this$esElectronica == null ? other$esElectronica != null : !((Object)this$esElectronica).equals(other$esElectronica)) {
            return false;
        }
        Boolean this$activa = this.getActiva();
        Boolean other$activa = other.getActiva();
        if (this$activa == null ? other$activa != null : !((Object)this$activa).equals(other$activa)) {
            return false;
        }
        TipoComprobante this$tipoComprobante = this.getTipoComprobante();
        TipoComprobante other$tipoComprobante = other.getTipoComprobante();
        if (this$tipoComprobante == null ? other$tipoComprobante != null : !this$tipoComprobante.equals(other$tipoComprobante)) {
            return false;
        }
        String this$serie = this.getSerie();
        String other$serie = other.getSerie();
        if (this$serie == null ? other$serie != null : !this$serie.equals(other$serie)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        return !(this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TiendaSerie;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $sedeId = this.getSedeId();
        result = result * 59 + ($sedeId == null ? 43 : ((Object)$sedeId).hashCode());
        Integer $correlativoActual = this.getCorrelativoActual();
        result = result * 59 + ($correlativoActual == null ? 43 : ((Object)$correlativoActual).hashCode());
        Boolean $esElectronica = this.getEsElectronica();
        result = result * 59 + ($esElectronica == null ? 43 : ((Object)$esElectronica).hashCode());
        Boolean $activa = this.getActiva();
        result = result * 59 + ($activa == null ? 43 : ((Object)$activa).hashCode());
        TipoComprobante $tipoComprobante = this.getTipoComprobante();
        result = result * 59 + ($tipoComprobante == null ? 43 : $tipoComprobante.hashCode());
        String $serie = this.getSerie();
        result = result * 59 + ($serie == null ? 43 : $serie.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TiendaSerie(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", sedeId=" + this.getSedeId() + ", tipoComprobante=" + String.valueOf(this.getTipoComprobante()) + ", serie=" + this.getSerie() + ", correlativoActual=" + this.getCorrelativoActual() + ", esElectronica=" + this.getEsElectronica() + ", activa=" + this.getActiva() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ")";
    }
}

