/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.facturacion.controller;

import com.dulcecontrol.bakery.features.admin.facturacion.dto.TiendaSerieRequest;
import com.dulcecontrol.bakery.features.admin.facturacion.dto.TiendaSerieResponse;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.TipoComprobante;
import com.dulcecontrol.bakery.features.admin.facturacion.service.TiendaSerieService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/facturacion/series"})
public class TiendaSerieController {
    private final TiendaSerieService tiendaSerieService;

    @GetMapping
    public ResponseEntity<List<TiendaSerieResponse>> listar(@PathVariable Long tiendaId) {
        List response = this.tiendaSerieService.listarPorTienda(tiendaId);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{serieId}"})
    public ResponseEntity<TiendaSerieResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long serieId) {
        TiendaSerieResponse response = this.tiendaSerieService.obtenerPorIdYTienda(serieId, tiendaId);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<TiendaSerieResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody TiendaSerieRequest request) {
        TiendaSerieResponse response = this.tiendaSerieService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{serieId}"})
    public ResponseEntity<TiendaSerieResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long serieId, @Valid @RequestBody TiendaSerieRequest request) {
        TiendaSerieResponse response = this.tiendaSerieService.actualizar(tiendaId, serieId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{serieId}"})
    public ResponseEntity<Void> desactivar(@PathVariable Long tiendaId, @PathVariable Long serieId) {
        this.tiendaSerieService.desactivar(tiendaId, serieId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/activas"})
    public ResponseEntity<List<TiendaSerieResponse>> listarActivas(@PathVariable Long tiendaId) {
        List response = this.tiendaSerieService.listarActivasPorTienda(tiendaId);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/sede/{sedeId}"})
    public ResponseEntity<List<TiendaSerieResponse>> listarPorSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        List response = this.tiendaSerieService.listarPorTiendaYSede(tiendaId, sedeId);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/tipo/{tipoComprobante}"})
    public ResponseEntity<List<TiendaSerieResponse>> listarPorTipo(@PathVariable Long tiendaId, @PathVariable TipoComprobante tipoComprobante) {
        List response = this.tiendaSerieService.listarActivasPorTiendaYTipo(tiendaId, tipoComprobante);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{serieId}/activar"})
    public ResponseEntity<Void> activar(@PathVariable Long tiendaId, @PathVariable Long serieId) {
        this.tiendaSerieService.activar(tiendaId, serieId);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{serieId}/incrementar-correlativo"})
    public ResponseEntity<Integer> incrementarCorrelativo(@PathVariable Long tiendaId, @PathVariable Long serieId) {
        Integer nuevoCorrelativo = this.tiendaSerieService.incrementarCorrelativo(tiendaId, serieId);
        return ResponseEntity.ok((Object)nuevoCorrelativo);
    }

    @Generated
    public TiendaSerieController(TiendaSerieService tiendaSerieService) {
        this.tiendaSerieService = tiendaSerieService;
    }
}

