/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.service.impl;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontCreateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.entity.PaginaStorefront;
import com.dulcecontrol.bakery.features.admin.configuracion.repository.PaginaStorefrontRepository;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IPaginaStorefrontService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaginaStorefrontService
implements IPaginaStorefrontService {
    private final PaginaStorefrontRepository paginaStorefrontRepository;

    @Transactional(readOnly=true)
    public List<PaginaStorefrontResponse> listarPorTienda(Long tiendaId) {
        return this.paginaStorefrontRepository.findByTiendaId(tiendaId).stream().sorted(Comparator.comparing(PaginaStorefront::getOrdenMenu)).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<PaginaStorefrontResponse> buscarPorTiendaYTexto(Long tiendaId, String busqueda) {
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.listarPorTienda(tiendaId);
        }
        return this.paginaStorefrontRepository.buscarPorTiendaYTexto(tiendaId, busqueda.trim()).stream().sorted(Comparator.comparing(PaginaStorefront::getOrdenMenu)).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public PaginaStorefrontResponse obtenerPorId(Long tiendaId, Long paginaId) {
        PaginaStorefront pagina = (PaginaStorefront)this.paginaStorefrontRepository.findByIdAndTiendaId(paginaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("P\u00e1gina no encontrada"));
        return this.toResponse(pagina);
    }

    @Transactional
    public PaginaStorefrontResponse crear(Long tiendaId, PaginaStorefrontCreateRequest request) {
        if (this.paginaStorefrontRepository.existsByTiendaIdAndSlug(tiendaId, request.getSlug())) {
            throw new BadRequestException("Ya existe una p\u00e1gina con el mismo slug");
        }
        PaginaStorefront pagina = new PaginaStorefront();
        pagina.setTiendaId(tiendaId);
        pagina.setSlug(request.getSlug());
        pagina.setTitulo(request.getTitulo());
        pagina.setContenido(request.getContenido());
        pagina.setMetaDescripcion(request.getMetaDescripcion());
        pagina.setTipoContenido(request.getTipoContenido());
        pagina.setOrdenMenu(request.getOrdenMenu());
        pagina.setVisibleEnMenu(request.getVisibleEnMenu());
        pagina.setActiva(request.getActiva());
        PaginaStorefront saved = (PaginaStorefront)this.paginaStorefrontRepository.save((Object)pagina);
        return this.toResponse(saved);
    }

    @Transactional
    public PaginaStorefrontResponse actualizar(Long tiendaId, Long paginaId, PaginaStorefrontUpdateRequest request) {
        PaginaStorefront pagina = (PaginaStorefront)this.paginaStorefrontRepository.findByIdAndTiendaId(paginaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("P\u00e1gina no encontrada"));
        if (this.paginaStorefrontRepository.existsByTiendaIdAndSlugAndIdNot(tiendaId, request.getSlug(), paginaId)) {
            throw new BadRequestException("Ya existe otra p\u00e1gina con el mismo slug");
        }
        pagina.setSlug(request.getSlug());
        pagina.setTitulo(request.getTitulo());
        pagina.setContenido(request.getContenido());
        pagina.setMetaDescripcion(request.getMetaDescripcion());
        pagina.setTipoContenido(request.getTipoContenido());
        pagina.setOrdenMenu(request.getOrdenMenu());
        pagina.setVisibleEnMenu(request.getVisibleEnMenu());
        pagina.setActiva(request.getActiva());
        PaginaStorefront saved = (PaginaStorefront)this.paginaStorefrontRepository.save((Object)pagina);
        return this.toResponse(saved);
    }

    @Transactional(readOnly=true)
    public PaginaStorefrontResponse obtenerPorSlug(Long tiendaId, String slug) {
        PaginaStorefront pagina = (PaginaStorefront)this.paginaStorefrontRepository.findByTiendaIdAndSlug(tiendaId, slug).orElseThrow(() -> new ResourceNotFoundException("P\u00e1gina no encontrada"));
        return this.toResponse(pagina);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long paginaId) {
        PaginaStorefront pagina = (PaginaStorefront)this.paginaStorefrontRepository.findByIdAndTiendaId(paginaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("P\u00e1gina no encontrada"));
        this.paginaStorefrontRepository.delete((Object)pagina);
    }

    private PaginaStorefrontResponse toResponse(PaginaStorefront pagina) {
        return PaginaStorefrontResponse.builder().id(pagina.getId()).tiendaId(pagina.getTiendaId()).slug(pagina.getSlug()).titulo(pagina.getTitulo()).contenido(pagina.getContenido()).metaDescripcion(pagina.getMetaDescripcion()).tipoContenido(pagina.getTipoContenido()).ordenMenu(pagina.getOrdenMenu()).visibleEnMenu(pagina.getVisibleEnMenu()).activa(pagina.getActiva()).creadoEn(pagina.getCreadoEn()).actualizadoEn(pagina.getActualizadoEn()).build();
    }

    @Generated
    public PaginaStorefrontService(PaginaStorefrontRepository paginaStorefrontRepository) {
        this.paginaStorefrontRepository = paginaStorefrontRepository;
    }
}

