/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.service.impl;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionPublicaResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionPublicaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.entity.ConfiguracionTienda;
import com.dulcecontrol.bakery.features.admin.configuracion.repository.ConfiguracionTiendaRepository;
import com.dulcecontrol.bakery.features.admin.configuracion.repository.DominioTiendaAdminRepository;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IConfiguracionPublicaService;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.DominioTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.enums.TipoDominioTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.TiendaRepository;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfiguracionPublicaService
implements IConfiguracionPublicaService {
    private final ConfiguracionTiendaRepository configuracionTiendaRepository;
    private final DominioTiendaAdminRepository dominioTiendaAdminRepository;
    private final TiendaRepository tiendaRepository;

    @Transactional(readOnly=true)
    public ConfiguracionPublicaResponse obtenerConfiguracionPublica(Long tiendaId) {
        Tienda tienda = (Tienda)this.tiendaRepository.findById((Object)tiendaId).orElseThrow(() -> new ResourceNotFoundException("Tienda no encontrada"));
        ConfiguracionTienda config = (ConfiguracionTienda)this.configuracionTiendaRepository.findByTiendaId(tiendaId).orElseThrow(() -> new ResourceNotFoundException("Configuraci\u00f3n de tienda no encontrada"));
        DominioTienda dominio = (DominioTienda)this.dominioTiendaAdminRepository.findByTienda_IdAndTipo(tiendaId, TipoDominioTienda.TIENDA_VIRTUAL).orElseThrow(() -> new ResourceNotFoundException("Dominio de tienda virtual no encontrado"));
        return ConfiguracionPublicaResponse.builder().tiendaId(tiendaId).nombreTienda(tienda.getNombreComercial()).sloganParte1(config.getSloganParte1()).sloganParte2(config.getSloganParte2()).bannerPrincipalUrl(config.getBannerPrincipalUrl()).mensajeBienvenida(config.getMensajeBienvenida()).horarioAtencion(config.getHorarioAtencion()).redesSociales(config.getRedesSociales()).urlLogo(dominio.getUrlLogo()).urlFavicon(dominio.getUrlFavicon()).colorPrimario(dominio.getColorPrimario()).colorSecundario(dominio.getColorSecundario()).build();
    }

    @Transactional
    public ConfiguracionPublicaResponse actualizarConfiguracionPublica(Long tiendaId, ConfiguracionPublicaUpdateRequest request) {
        ConfiguracionTienda config = (ConfiguracionTienda)this.configuracionTiendaRepository.findByTiendaId(tiendaId).orElseThrow(() -> new ResourceNotFoundException("Configuraci\u00f3n de tienda no encontrada"));
        config.setSloganParte1(request.getSloganParte1());
        config.setSloganParte2(request.getSloganParte2());
        config.setBannerPrincipalUrl(request.getBannerPrincipalUrl());
        config.setMensajeBienvenida(request.getMensajeBienvenida());
        config.setHorarioAtencion(request.getHorarioAtencion());
        config.setRedesSociales(request.getRedesSociales());
        this.configuracionTiendaRepository.save((Object)config);
        return this.obtenerConfiguracionPublica(tiendaId);
    }

    @Generated
    public ConfiguracionPublicaService(ConfiguracionTiendaRepository configuracionTiendaRepository, DominioTiendaAdminRepository dominioTiendaAdminRepository, TiendaRepository tiendaRepository) {
        this.configuracionTiendaRepository = configuracionTiendaRepository;
        this.dominioTiendaAdminRepository = dominioTiendaAdminRepository;
        this.tiendaRepository = tiendaRepository;
    }
}

