/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.SedeCreateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.SedeResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.SedeUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.service.ISedeAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/configuracion/sedes"})
public class SedeAdminController {
    private final ISedeAdminService sedeService;

    @GetMapping
    public ResponseEntity<List<SedeResponse>> obtenerSedes(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.sedeService.obtenerSedesPorTienda(tiendaId));
    }

    @GetMapping(value={"/{sedeId}"})
    public ResponseEntity<SedeResponse> obtenerSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        return ResponseEntity.ok((Object)this.sedeService.obtenerSedePorId(tiendaId, sedeId));
    }

    @PostMapping
    public ResponseEntity<SedeResponse> crearSede(@PathVariable Long tiendaId, @Valid @RequestBody SedeCreateRequest request) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.sedeService.crearSede(tiendaId, request));
    }

    @PutMapping(value={"/{sedeId}"})
    public ResponseEntity<SedeResponse> actualizarSede(@PathVariable Long tiendaId, @PathVariable Long sedeId, @Valid @RequestBody SedeUpdateRequest request) {
        return ResponseEntity.ok((Object)this.sedeService.actualizarSede(tiendaId, sedeId, request));
    }

    @DeleteMapping(value={"/{sedeId}"})
    public ResponseEntity<Void> eliminarSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        this.sedeService.eliminarSede(tiendaId, sedeId);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/{sedeId}/desactivar"})
    public ResponseEntity<Void> desactivarSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        this.sedeService.desactivarSede(tiendaId, sedeId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public SedeAdminController(ISedeAdminService sedeService) {
        this.sedeService = sedeService;
    }
}

