/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontCreateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IPaginaStorefrontService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/paginas-storefront"})
@Validated
public class PaginaStorefrontController {
    private final IPaginaStorefrontService paginaStorefrontService;

    @GetMapping
    public ResponseEntity<List<PaginaStorefrontResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.paginaStorefrontService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/buscar"})
    public ResponseEntity<List<PaginaStorefrontResponse>> buscar(@PathVariable Long tiendaId, @RequestParam(required=false) String q) {
        return ResponseEntity.ok((Object)this.paginaStorefrontService.buscarPorTiendaYTexto(tiendaId, q));
    }

    @GetMapping(value={"/{paginaId}"})
    public ResponseEntity<PaginaStorefrontResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long paginaId) {
        return ResponseEntity.ok((Object)this.paginaStorefrontService.obtenerPorId(tiendaId, paginaId));
    }

    @PostMapping
    public ResponseEntity<PaginaStorefrontResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody PaginaStorefrontCreateRequest request) {
        PaginaStorefrontResponse response = this.paginaStorefrontService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{paginaId}"})
    public ResponseEntity<PaginaStorefrontResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long paginaId, @Valid @RequestBody PaginaStorefrontUpdateRequest request) {
        PaginaStorefrontResponse response = this.paginaStorefrontService.actualizar(tiendaId, paginaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{paginaId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long paginaId) {
        this.paginaStorefrontService.eliminar(tiendaId, paginaId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public PaginaStorefrontController(IPaginaStorefrontService paginaStorefrontService) {
        this.paginaStorefrontService = paginaStorefrontService;
    }
}

