/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.DatosEmpresaResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.DatosEmpresaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IDatosEmpresaService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/configuracion/datos-empresa"})
@Validated
public class DatosEmpresaController {
    private final IDatosEmpresaService datosEmpresaService;

    @GetMapping
    public ResponseEntity<DatosEmpresaResponse> obtener(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.datosEmpresaService.obtenerPorTiendaId(tiendaId));
    }

    @PutMapping
    public ResponseEntity<DatosEmpresaResponse> actualizar(@PathVariable Long tiendaId, @Valid @RequestBody DatosEmpresaUpdateRequest request) {
        DatosEmpresaResponse response = this.datosEmpresaService.actualizar(tiendaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public DatosEmpresaController(IDatosEmpresaService datosEmpresaService) {
        this.datosEmpresaService = datosEmpresaService;
    }
}

