/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.service.impl;

import com.dulcecontrol.bakery.features.admin.compras.dto.DetalleOrdenCompraRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.DetalleOrdenCompraResponse;
import com.dulcecontrol.bakery.features.admin.compras.dto.OrdenCompraCreateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.OrdenCompraResponse;
import com.dulcecontrol.bakery.features.admin.compras.dto.OrdenCompraUpdateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.RecepcionParcialRequest;
import com.dulcecontrol.bakery.features.admin.compras.entity.DetalleOrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.OrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.PagoOrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.EstadoOrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.MetodoPago;
import com.dulcecontrol.bakery.features.admin.compras.repository.DetalleOrdenCompraRepository;
import com.dulcecontrol.bakery.features.admin.compras.repository.InsumoRepository;
import com.dulcecontrol.bakery.features.admin.compras.repository.OrdenCompraRepository;
import com.dulcecontrol.bakery.features.admin.compras.repository.PagoOrdenCompraRepository;
import com.dulcecontrol.bakery.features.admin.compras.repository.ProveedorRepository;
import com.dulcecontrol.bakery.features.admin.compras.service.IOrdenCompraService;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioInsumoSede;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.TipoMovimientoInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioInsumoSedeRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioInsumoRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.SedeRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrdenCompraService
implements IOrdenCompraService {
    private final OrdenCompraRepository ordenCompraRepository;
    private final DetalleOrdenCompraRepository detalleOrdenCompraRepository;
    private final ProveedorRepository proveedorRepository;
    private final SedeRepository sedeRepository;
    private final InsumoRepository insumoRepository;
    private final InventarioInsumoSedeRepository inventarioInsumoSedeRepository;
    private final PagoOrdenCompraRepository pagoOrdenCompraRepository;
    private final MovimientoInventarioInsumoRepository movimientoInventarioInsumoRepository;

    @Transactional(readOnly=true)
    public List<OrdenCompraResponse> listarPorTienda(Long tiendaId) {
        return this.ordenCompraRepository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<OrdenCompraResponse> listarPorTiendaYEstado(Long tiendaId, EstadoOrdenCompra estado) {
        return this.ordenCompraRepository.findByTiendaIdAndEstado(tiendaId, estado).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<OrdenCompraResponse> listarPorSede(Long sedeId) {
        return this.ordenCompraRepository.findBySedeDestino(sedeId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<OrdenCompraResponse> listarPorProveedor(Long proveedorId) {
        return this.ordenCompraRepository.findByProveedor(proveedorId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<OrdenCompraResponse> listarOrdenesPendientes(Long sedeId) {
        List<EstadoOrdenCompra> estadosPendientes = List.of(EstadoOrdenCompra.ENVIADA, EstadoOrdenCompra.RECIBIDA_PARCIAL);
        return this.ordenCompraRepository.findOrdenesPendientesPorSede(sedeId, estadosPendientes, LocalDate.now()).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<OrdenCompraResponse> listarPorFechas(Long tiendaId, LocalDate fechaInicio, LocalDate fechaFin) {
        return this.ordenCompraRepository.findByTiendaIdAndFechaEmisionBetween(tiendaId, fechaInicio, fechaFin).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public OrdenCompraResponse obtenerPorId(Long tiendaId, Long ordenCompraId) {
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findByIdAndTiendaId(ordenCompraId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Orden de compra no encontrada"));
        return this.toResponse(orden);
    }

    @Transactional
    public OrdenCompraResponse crear(OrdenCompraCreateRequest request) {
        OrdenCompra orden = new OrdenCompra();
        orden.setTiendaId(request.getTiendaId());
        orden.setSedeDestinoId(request.getSedeDestinoId());
        orden.setProveedorId(request.getProveedorId());
        orden.setFechaEmision(request.getFechaEmision());
        orden.setFechaRecepcionEsperada(request.getFechaRecepcionEsperada());
        orden.setEstado(request.getEstado() != null ? request.getEstado() : EstadoOrdenCompra.BORRADOR);
        orden.setMoneda(request.getMoneda() != null ? request.getMoneda() : "PEN");
        orden.setMetodoPago(request.getMetodoPago());
        Long totalCentimos = this.calcularTotal(request.getDetalles());
        orden.setTotalCompraCentimos(totalCentimos);
        if (request.getMetodoPago() != null && request.getMetodoPago() == MetodoPago.CREDITO) {
            Long montoInicial = request.getMontoInicialCentimos() != null ? request.getMontoInicialCentimos() : 0L;
            orden.setMontoInicialCentimos(montoInicial);
            orden.setMontoPagadoCentimos(montoInicial);
            orden.setSaldoPendienteCentimos(Long.valueOf(totalCentimos - montoInicial));
        } else if (request.getMetodoPago() != null && request.getMetodoPago() == MetodoPago.EFECTIVO) {
            orden.setMontoInicialCentimos(totalCentimos);
            orden.setMontoPagadoCentimos(totalCentimos);
            orden.setSaldoPendienteCentimos(Long.valueOf(0L));
        } else {
            orden.setMontoInicialCentimos(Long.valueOf(0L));
            orden.setMontoPagadoCentimos(Long.valueOf(0L));
            orden.setSaldoPendienteCentimos(Long.valueOf(0L));
        }
        orden.setReferenciaPago(request.getReferenciaPago());
        orden.setTipoComprobanteProveedor(request.getTipoComprobanteProveedor());
        orden.setSerieComprobanteProveedor(request.getSerieComprobanteProveedor());
        orden.setNumeroComprobanteProveedor(request.getNumeroComprobanteProveedor());
        orden.setUrlFotoComprobante(request.getUrlFotoComprobante());
        orden.setObservaciones(request.getObservaciones());
        orden.setRegistradoPor(request.getRegistradoPor());
        OrdenCompra guardada = (OrdenCompra)this.ordenCompraRepository.save((Object)orden);
        for (DetalleOrdenCompraRequest detalle : request.getDetalles()) {
            DetalleOrdenCompra detalleEntity = new DetalleOrdenCompra();
            detalleEntity.setOrdenCompraId(guardada.getId());
            detalleEntity.setInsumoId(detalle.getInsumoId());
            detalleEntity.setCantidadSolicitada(detalle.getCantidadSolicitada());
            detalleEntity.setUnidadCompra(detalle.getUnidadCompra());
            detalleEntity.setCostoUnitarioPactadoCentimos(detalle.getCostoUnitarioPactadoCentimos());
            Long totalLinea = this.calcularTotalLinea(detalle.getCantidadSolicitada(), detalle.getCostoUnitarioPactadoCentimos());
            detalleEntity.setTotalLineaCentimos(totalLinea);
            detalleEntity.setCantidadRecibida(detalle.getCantidadRecibida());
            detalleEntity.setRecibidoCompleto(detalle.getRecibidoCompleto());
            this.detalleOrdenCompraRepository.save((Object)detalleEntity);
        }
        if (request.getMetodoPago() == MetodoPago.CREDITO && request.getMontoInicialCentimos() != null && request.getMontoInicialCentimos() > 0L) {
            PagoOrdenCompra pagoInicial = new PagoOrdenCompra();
            pagoInicial.setOrdenCompraId(guardada.getId());
            pagoInicial.setFechaPago(request.getFechaEmision() != null ? request.getFechaEmision() : LocalDate.now());
            pagoInicial.setMontoPagadoCentimos(request.getMontoInicialCentimos());
            pagoInicial.setMetodoPago(request.getTipoPagoInicial());
            pagoInicial.setReferenciaPago(request.getReferenciaPago());
            pagoInicial.setUrlFotoComprobante(request.getUrlFotoComprobante());
            pagoInicial.setObservaciones("Pago inicial al crear la orden");
            this.pagoOrdenCompraRepository.save((Object)pagoInicial);
            System.out.println("=== PAGO INICIAL REGISTRADO ===");
            System.out.println("Orden ID: " + guardada.getId());
            System.out.println("Monto pagado: " + request.getMontoInicialCentimos());
            System.out.println("Tiene comprobante: " + (request.getUrlFotoComprobante() != null));
            System.out.println("================================");
        }
        return this.toResponse(guardada);
    }

    @Transactional
    public OrdenCompraResponse actualizar(Long tiendaId, Long ordenCompraId, OrdenCompraUpdateRequest request) {
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findByIdAndTiendaId(ordenCompraId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Orden de compra no encontrada"));
        orden.setSedeDestinoId(request.getSedeDestinoId());
        orden.setProveedorId(request.getProveedorId());
        if (request.getFechaEmision() != null) {
            orden.setFechaEmision(request.getFechaEmision());
        }
        if (request.getFechaRecepcionEsperada() != null) {
            orden.setFechaRecepcionEsperada(request.getFechaRecepcionEsperada());
        }
        if (request.getFechaRecepcionReal() != null) {
            orden.setFechaRecepcionReal(request.getFechaRecepcionReal());
        }
        if (request.getEstado() != null) {
            orden.setEstado(request.getEstado());
        }
        if (request.getMoneda() != null) {
            orden.setMoneda(request.getMoneda());
        }
        orden.setMetodoPago(request.getMetodoPago());
        orden.setReferenciaPago(request.getReferenciaPago());
        orden.setTipoComprobanteProveedor(request.getTipoComprobanteProveedor());
        orden.setSerieComprobanteProveedor(request.getSerieComprobanteProveedor());
        orden.setNumeroComprobanteProveedor(request.getNumeroComprobanteProveedor());
        orden.setUrlFotoComprobante(request.getUrlFotoComprobante());
        orden.setObservaciones(request.getObservaciones());
        if (request.getDetalles() != null && !request.getDetalles().isEmpty()) {
            this.detalleOrdenCompraRepository.deleteByOrdenCompraId(ordenCompraId);
            for (DetalleOrdenCompraRequest detalle : request.getDetalles()) {
                DetalleOrdenCompra detalleEntity = new DetalleOrdenCompra();
                detalleEntity.setOrdenCompraId(orden.getId());
                detalleEntity.setInsumoId(detalle.getInsumoId());
                detalleEntity.setCantidadSolicitada(detalle.getCantidadSolicitada());
                detalleEntity.setUnidadCompra(detalle.getUnidadCompra());
                detalleEntity.setCostoUnitarioPactadoCentimos(detalle.getCostoUnitarioPactadoCentimos());
                Long totalLinea = this.calcularTotalLinea(detalle.getCantidadSolicitada(), detalle.getCostoUnitarioPactadoCentimos());
                detalleEntity.setTotalLineaCentimos(totalLinea);
                detalleEntity.setCantidadRecibida(detalle.getCantidadRecibida());
                detalleEntity.setRecibidoCompleto(detalle.getRecibidoCompleto());
                this.detalleOrdenCompraRepository.save((Object)detalleEntity);
            }
            Long totalCentimos = this.calcularTotal(request.getDetalles());
            orden.setTotalCompraCentimos(totalCentimos);
        }
        OrdenCompra actualizada = (OrdenCompra)this.ordenCompraRepository.save((Object)orden);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long ordenCompraId) {
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findByIdAndTiendaId(ordenCompraId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Orden de compra no encontrada"));
        if (orden.getEstado() != EstadoOrdenCompra.BORRADOR) {
            throw new BadRequestException("Solo se pueden eliminar \u00f3rdenes en estado borrador");
        }
        this.detalleOrdenCompraRepository.deleteByOrdenCompraId(ordenCompraId);
        this.ordenCompraRepository.delete((Object)orden);
    }

    @Transactional
    public OrdenCompraResponse cambiarEstado(Long tiendaId, Long ordenCompraId, EstadoOrdenCompra nuevoEstado) {
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findByIdAndTiendaId(ordenCompraId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Orden de compra no encontrada"));
        this.validarCambioEstado(orden.getEstado(), nuevoEstado);
        orden.setEstado(nuevoEstado);
        if (nuevoEstado == EstadoOrdenCompra.RECIBIDA_TOTAL && orden.getFechaRecepcionReal() == null) {
            orden.setFechaRecepcionReal(LocalDate.now());
        }
        OrdenCompra actualizada = (OrdenCompra)this.ordenCompraRepository.save((Object)orden);
        return this.toResponse(actualizada);
    }

    private void validarCambioEstado(EstadoOrdenCompra estadoActual, EstadoOrdenCompra nuevoEstado) {
        if (estadoActual == EstadoOrdenCompra.CANCELADA) {
            throw new BadRequestException("No se puede cambiar el estado de una orden cancelada");
        }
        if (estadoActual == EstadoOrdenCompra.RECIBIDA_TOTAL && nuevoEstado != EstadoOrdenCompra.CANCELADA) {
            throw new BadRequestException("No se puede cambiar el estado de una orden ya recibida totalmente");
        }
    }

    private Long calcularTotal(List<DetalleOrdenCompraRequest> detalles) {
        return detalles.stream().mapToLong(detalle -> this.calcularTotalLinea(detalle.getCantidadSolicitada(), detalle.getCostoUnitarioPactadoCentimos())).sum();
    }

    private Long calcularTotalLinea(BigDecimal cantidad, Long costoUnitarioCentimos) {
        return cantidad.multiply(new BigDecimal(costoUnitarioCentimos)).longValue();
    }

    private OrdenCompraResponse toResponse(OrdenCompra orden) {
        List detalles = this.detalleOrdenCompraRepository.findByOrdenCompraId(orden.getId());
        String nombreProveedor = this.proveedorRepository.findById((Object)orden.getProveedorId()).map(p -> p.getNombreComercial()).orElse("Proveedor no encontrado");
        String nombreSede = this.sedeRepository.findById((Object)orden.getSedeDestinoId()).map(s -> s.getNombre()).orElse("Sede no encontrada");
        return OrdenCompraResponse.builder().id(orden.getId()).tiendaId(orden.getTiendaId()).sedeDestinoId(orden.getSedeDestinoId()).nombreSede(nombreSede).proveedorId(orden.getProveedorId()).nombreProveedor(nombreProveedor).fechaEmision(orden.getFechaEmision()).fechaRecepcionEsperada(orden.getFechaRecepcionEsperada()).fechaRecepcionReal(orden.getFechaRecepcionReal()).estado(orden.getEstado()).moneda(orden.getMoneda()).totalCompraCentimos(orden.getTotalCompraCentimos()).metodoPago(orden.getMetodoPago()).montoInicialCentimos(orden.getMontoInicialCentimos()).montoPagadoCentimos(orden.getMontoPagadoCentimos()).saldoPendienteCentimos(orden.getSaldoPendienteCentimos()).referenciaPago(orden.getReferenciaPago()).tipoComprobanteProveedor(orden.getTipoComprobanteProveedor()).serieComprobanteProveedor(orden.getSerieComprobanteProveedor()).numeroComprobanteProveedor(orden.getNumeroComprobanteProveedor()).urlFotoComprobante(orden.getUrlFotoComprobante()).observaciones(orden.getObservaciones()).registradoPor(orden.getRegistradoPor()).creadoEn(orden.getCreadoEn()).actualizadoEn(orden.getActualizadoEn()).detalles(detalles.stream().map(arg_0 -> this.toDetalleResponse(arg_0)).collect(Collectors.toList())).build();
    }

    private DetalleOrdenCompraResponse toDetalleResponse(DetalleOrdenCompra detalle) {
        String nombreInsumo = this.insumoRepository.findById((Object)detalle.getInsumoId()).map(i -> i.getNombre()).orElse("Insumo no encontrado");
        return DetalleOrdenCompraResponse.builder().id(detalle.getId()).ordenCompraId(detalle.getOrdenCompraId()).insumoId(detalle.getInsumoId()).nombreInsumo(nombreInsumo).cantidadSolicitada(detalle.getCantidadSolicitada()).unidadCompra(detalle.getUnidadCompra()).costoUnitarioPactadoCentimos(detalle.getCostoUnitarioPactadoCentimos()).totalLineaCentimos(detalle.getTotalLineaCentimos()).cantidadRecibida(detalle.getCantidadRecibida()).recibidoCompleto(detalle.getRecibidoCompleto()).build();
    }

    @Transactional
    public OrdenCompraResponse recibirParcial(Long tiendaId, RecepcionParcialRequest request) {
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findByIdAndTiendaId(request.getOrdenCompraId(), tiendaId).orElseThrow(() -> new ResourceNotFoundException("Orden de compra no encontrada"));
        if (orden.getEstado() != EstadoOrdenCompra.ENVIADA && orden.getEstado() != EstadoOrdenCompra.RECIBIDA_PARCIAL) {
            throw new BadRequestException("Solo se pueden recibir \u00f3rdenes en estado ENVIADA o RECIBIDA_PARCIAL");
        }
        for (RecepcionParcialRequest.ItemRecepcionParcial item : request.getItems()) {
            DetalleOrdenCompra detalle = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.findById((Object)item.getDetalleOrdenCompraId()).orElseThrow(() -> new ResourceNotFoundException("Detalle de orden no encontrado"));
            if (!detalle.getOrdenCompraId().equals(orden.getId())) {
                throw new BadRequestException("El detalle no pertenece a esta orden");
            }
            BigDecimal cantidadAnterior = detalle.getCantidadRecibida() != null ? detalle.getCantidadRecibida() : BigDecimal.ZERO;
            BigDecimal cantidadRecibidaAhora = BigDecimal.valueOf(item.getCantidadRecibida());
            BigDecimal nuevaCantidadRecibida = cantidadAnterior.add(cantidadRecibidaAhora);
            detalle.setCantidadRecibida(nuevaCantidadRecibida);
            if (nuevaCantidadRecibida.compareTo(detalle.getCantidadSolicitada()) >= 0) {
                detalle.setRecibidoCompleto(Boolean.valueOf(true));
            }
            this.detalleOrdenCompraRepository.save((Object)detalle);
            this.actualizarInventario(orden.getTiendaId(), orden.getSedeDestinoId(), detalle.getInsumoId(), cantidadRecibidaAhora);
            System.out.println("=== REGISTRANDO MOVIMIENTO INVENTARIO ===");
            System.out.println("TiendaId: " + orden.getTiendaId());
            System.out.println("SedeId: " + orden.getSedeDestinoId());
            System.out.println("InsumoId: " + detalle.getInsumoId());
            System.out.println("Cantidad recibida: " + String.valueOf(cantidadRecibidaAhora));
            System.out.println("Orden ID: " + orden.getId());
            this.registrarMovimientoInventario(orden.getTiendaId(), orden.getSedeDestinoId(), detalle.getInsumoId(), cantidadRecibidaAhora, orden.getId(), "Recepci\u00f3n de orden de compra #" + orden.getId());
            System.out.println("\u2705 Movimiento registrado exitosamente");
            System.out.println("=========================================");
        }
        List todosDetalles = this.detalleOrdenCompraRepository.findByOrdenCompraId(orden.getId());
        boolean todosCompletos = todosDetalles.stream().allMatch(d -> d.getRecibidoCompleto() != null && d.getRecibidoCompleto() != false);
        if (todosCompletos) {
            orden.setEstado(EstadoOrdenCompra.RECIBIDA_TOTAL);
        } else {
            orden.setEstado(EstadoOrdenCompra.RECIBIDA_PARCIAL);
        }
        orden.setFechaRecepcionReal(LocalDate.now());
        OrdenCompra ordenActualizada = (OrdenCompra)this.ordenCompraRepository.save((Object)orden);
        return this.toResponse(ordenActualizada);
    }

    @Transactional
    public OrdenCompraResponse recibirTotal(Long tiendaId, Long ordenCompraId) {
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findByIdAndTiendaId(ordenCompraId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Orden de compra no encontrada"));
        if (orden.getEstado() != EstadoOrdenCompra.ENVIADA && orden.getEstado() != EstadoOrdenCompra.RECIBIDA_PARCIAL) {
            throw new BadRequestException("Solo se pueden recibir totalmente \u00f3rdenes en estado ENVIADA o RECIBIDA_PARCIAL");
        }
        List detalles = this.detalleOrdenCompraRepository.findByOrdenCompraId(ordenCompraId);
        for (DetalleOrdenCompra detalle : detalles) {
            BigDecimal cantidadRecibida;
            BigDecimal bigDecimal = cantidadRecibida = detalle.getCantidadRecibida() != null ? detalle.getCantidadRecibida() : BigDecimal.ZERO;
            BigDecimal cantidadFaltante = detalle.getCantidadSolicitada().subtract(cantidadRecibida);
            if (cantidadFaltante.compareTo(BigDecimal.ZERO) <= 0) continue;
            detalle.setCantidadRecibida(detalle.getCantidadSolicitada());
            detalle.setRecibidoCompleto(Boolean.valueOf(true));
            this.detalleOrdenCompraRepository.save((Object)detalle);
            this.actualizarInventario(orden.getTiendaId(), orden.getSedeDestinoId(), detalle.getInsumoId(), cantidadFaltante);
            System.out.println("=== REGISTRANDO MOVIMIENTO INVENTARIO (TOTAL) ===");
            System.out.println("TiendaId: " + orden.getTiendaId());
            System.out.println("SedeId: " + orden.getSedeDestinoId());
            System.out.println("InsumoId: " + detalle.getInsumoId());
            System.out.println("Cantidad faltante recibida: " + String.valueOf(cantidadFaltante));
            System.out.println("Orden ID: " + orden.getId());
            this.registrarMovimientoInventario(orden.getTiendaId(), orden.getSedeDestinoId(), detalle.getInsumoId(), cantidadFaltante, orden.getId(), "Recepci\u00f3n total de orden de compra #" + orden.getId());
            System.out.println("\u2705 Movimiento registrado exitosamente");
            System.out.println("==================================================");
        }
        orden.setEstado(EstadoOrdenCompra.RECIBIDA_TOTAL);
        orden.setFechaRecepcionReal(LocalDate.now());
        OrdenCompra ordenActualizada = (OrdenCompra)this.ordenCompraRepository.save((Object)orden);
        return this.toResponse(ordenActualizada);
    }

    private void registrarMovimientoInventario(Long tiendaId, Long sedeId, Long insumoId, BigDecimal cantidad, Long ordenCompraId, String motivo) {
        Optional inventarioOpt = this.inventarioInsumoSedeRepository.findBySedeIdAndInsumoId(sedeId, insumoId);
        BigDecimal cantidadAnterior = inventarioOpt.map(inv -> inv.getCantidadActual()).orElse(BigDecimal.ZERO);
        BigDecimal cantidadPosterior = cantidadAnterior.add(cantidad);
        MovimientoInventarioInsumo movimiento = new MovimientoInventarioInsumo();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(sedeId);
        movimiento.setInsumoId(insumoId);
        movimiento.setTipoMovimiento(TipoMovimientoInsumo.ENTRADA);
        movimiento.setCantidad(cantidad);
        movimiento.setCantidadAnterior(cantidadAnterior);
        movimiento.setCantidadPosterior(cantidadPosterior);
        movimiento.setOrdenCompraId(ordenCompraId);
        movimiento.setMotivo(motivo);
        this.movimientoInventarioInsumoRepository.save((Object)movimiento);
        System.out.println("\u2705 Movimiento de inventario registrado: ENTRADA de " + String.valueOf(cantidad) + " unidades de insumo #" + insumoId);
    }

    private void actualizarInventario(Long tiendaId, Long sedeId, Long insumoId, BigDecimal cantidadASumar) {
        Optional inventarioOpt = this.inventarioInsumoSedeRepository.findBySedeIdAndInsumoId(sedeId, insumoId);
        if (inventarioOpt.isPresent()) {
            InventarioInsumoSede inventario = (InventarioInsumoSede)inventarioOpt.get();
            inventario.setCantidadActual(inventario.getCantidadActual().add(cantidadASumar));
            this.inventarioInsumoSedeRepository.save((Object)inventario);
        } else {
            InventarioInsumoSede nuevoInventario = new InventarioInsumoSede();
            nuevoInventario.setTiendaId(tiendaId);
            nuevoInventario.setSedeId(sedeId);
            nuevoInventario.setInsumoId(insumoId);
            nuevoInventario.setCantidadActual(cantidadASumar);
            this.inventarioInsumoSedeRepository.save((Object)nuevoInventario);
        }
    }

    @Generated
    public OrdenCompraService(OrdenCompraRepository ordenCompraRepository, DetalleOrdenCompraRepository detalleOrdenCompraRepository, ProveedorRepository proveedorRepository, SedeRepository sedeRepository, InsumoRepository insumoRepository, InventarioInsumoSedeRepository inventarioInsumoSedeRepository, PagoOrdenCompraRepository pagoOrdenCompraRepository, MovimientoInventarioInsumoRepository movimientoInventarioInsumoRepository) {
        this.ordenCompraRepository = ordenCompraRepository;
        this.detalleOrdenCompraRepository = detalleOrdenCompraRepository;
        this.proveedorRepository = proveedorRepository;
        this.sedeRepository = sedeRepository;
        this.insumoRepository = insumoRepository;
        this.inventarioInsumoSedeRepository = inventarioInsumoSedeRepository;
        this.pagoOrdenCompraRepository = pagoOrdenCompraRepository;
        this.movimientoInventarioInsumoRepository = movimientoInventarioInsumoRepository;
    }
}

