/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.service.impl;

import com.dulcecontrol.bakery.features.admin.compras.dto.InsumoCreateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.InsumoResponse;
import com.dulcecontrol.bakery.features.admin.compras.dto.InsumoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.compras.entity.Insumo;
import com.dulcecontrol.bakery.features.admin.compras.repository.InsumoRepository;
import com.dulcecontrol.bakery.features.admin.compras.service.IInsumoService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InsumoService
implements IInsumoService {
    private final InsumoRepository insumoRepository;

    @Transactional(readOnly=true)
    public List<InsumoResponse> listarPorTienda(Long tiendaId) {
        return this.insumoRepository.findAll().stream().filter(insumo -> insumo.getTiendaId().equals(tiendaId)).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<InsumoResponse> listarActivos(Long tiendaId) {
        return this.insumoRepository.findByTiendaIdAndActivoTrue(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<InsumoResponse> listarConStockBajo(Long tiendaId) {
        return this.insumoRepository.findInsumosConStockBajo(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public InsumoResponse obtenerPorId(Long tiendaId, Long insumoId) {
        Insumo insumo = (Insumo)this.insumoRepository.findByIdAndTiendaId(insumoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Insumo no encontrado"));
        return this.toResponse(insumo);
    }

    @Transactional
    public InsumoResponse crear(InsumoCreateRequest request) {
        if (this.insumoRepository.existsByTiendaIdAndNombre(request.getTiendaId(), request.getNombre())) {
            throw new BadRequestException("Ya existe un insumo con ese nombre");
        }
        Insumo insumo = new Insumo();
        insumo.setTiendaId(request.getTiendaId());
        insumo.setNombre(request.getNombre());
        insumo.setCodigoInterno(request.getCodigoInterno());
        insumo.setUnidadBase(request.getUnidadBase());
        insumo.setUnidadCompraHabitual(request.getUnidadCompraHabitual());
        insumo.setFactorConversion(request.getFactorConversion());
        insumo.setCostoPromedioUnitarioCentimos(request.getCostoPromedioUnitarioCentimos());
        insumo.setUltimoPrecioCompraCentimos(request.getUltimoPrecioCompraCentimos());
        insumo.setStockActualGlobal(request.getStockActualGlobal());
        insumo.setStockMinimoGlobal(request.getStockMinimoGlobal());
        insumo.setActivo(Boolean.TRUE);
        Insumo guardado = (Insumo)this.insumoRepository.save((Object)insumo);
        return this.toResponse(guardado);
    }

    @Transactional
    public InsumoResponse actualizar(Long tiendaId, Long insumoId, InsumoUpdateRequest request) {
        Insumo insumo = (Insumo)this.insumoRepository.findByIdAndTiendaId(insumoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Insumo no encontrado"));
        if (!insumo.getNombre().equalsIgnoreCase(request.getNombre()) && this.insumoRepository.existsByTiendaIdAndNombreAndIdNot(tiendaId, request.getNombre(), insumoId)) {
            throw new BadRequestException("Ya existe un insumo con ese nombre");
        }
        insumo.setNombre(request.getNombre());
        insumo.setCodigoInterno(request.getCodigoInterno());
        insumo.setUnidadBase(request.getUnidadBase());
        insumo.setUnidadCompraHabitual(request.getUnidadCompraHabitual());
        insumo.setFactorConversion(request.getFactorConversion());
        insumo.setCostoPromedioUnitarioCentimos(request.getCostoPromedioUnitarioCentimos());
        insumo.setUltimoPrecioCompraCentimos(request.getUltimoPrecioCompraCentimos());
        insumo.setStockActualGlobal(request.getStockActualGlobal());
        insumo.setStockMinimoGlobal(request.getStockMinimoGlobal());
        if (request.getActivo() != null) {
            insumo.setActivo(request.getActivo());
        }
        Insumo actualizado = (Insumo)this.insumoRepository.save((Object)insumo);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long insumoId) {
        Insumo insumo = (Insumo)this.insumoRepository.findByIdAndTiendaId(insumoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Insumo no encontrado"));
        try {
            this.insumoRepository.delete((Object)insumo);
            this.insumoRepository.flush();
        }
        catch (Exception e) {
            Object mensaje = "No se puede eliminar el insumo porque est\u00e1 siendo usado en: ";
            mensaje = e.getMessage().contains("recetas") ? (String)mensaje + "recetas de productos" : (e.getMessage().contains("detalles_orden_compra") ? (String)mensaje + "\u00f3rdenes de compra" : (e.getMessage().contains("movimientos_inventario_insumos") ? (String)mensaje + "historial de movimientos" : (String)mensaje + "otros registros del sistema"));
            throw new IllegalStateException((String)mensaje + ". Debe eliminar primero esas referencias.");
        }
    }

    @Transactional
    public void desactivar(Long tiendaId, Long insumoId) {
        Insumo insumo = (Insumo)this.insumoRepository.findByIdAndTiendaId(insumoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Insumo no encontrado"));
        insumo.setActivo(Boolean.FALSE);
        this.insumoRepository.save((Object)insumo);
    }

    @Transactional
    public void reactivar(Long tiendaId, Long insumoId) {
        Insumo insumo = (Insumo)this.insumoRepository.findByIdAndTiendaId(insumoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Insumo no encontrado"));
        insumo.setActivo(Boolean.TRUE);
        this.insumoRepository.save((Object)insumo);
    }

    private InsumoResponse toResponse(Insumo insumo) {
        return InsumoResponse.builder().id(insumo.getId()).tiendaId(insumo.getTiendaId()).nombre(insumo.getNombre()).codigoInterno(insumo.getCodigoInterno()).unidadBase(insumo.getUnidadBase()).unidadCompraHabitual(insumo.getUnidadCompraHabitual()).factorConversion(insumo.getFactorConversion()).costoPromedioUnitarioCentimos(insumo.getCostoPromedioUnitarioCentimos()).ultimoPrecioCompraCentimos(insumo.getUltimoPrecioCompraCentimos()).stockActualGlobal(insumo.getStockActualGlobal()).stockMinimoGlobal(insumo.getStockMinimoGlobal()).activo(insumo.getActivo()).creadoEn(insumo.getCreadoEn()).build();
    }

    @Generated
    public InsumoService(InsumoRepository insumoRepository) {
        this.insumoRepository = insumoRepository;
    }
}

