/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.service.impl;

import com.dulcecontrol.bakery.features.admin.compras.dto.DetalleOrdenCompraRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.DetalleOrdenCompraResponse;
import com.dulcecontrol.bakery.features.admin.compras.entity.DetalleOrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.OrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.repository.DetalleOrdenCompraRepository;
import com.dulcecontrol.bakery.features.admin.compras.repository.OrdenCompraRepository;
import com.dulcecontrol.bakery.features.admin.compras.service.IDetalleOrdenCompraService;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DetalleOrdenCompraServiceImpl
implements IDetalleOrdenCompraService {
    private final DetalleOrdenCompraRepository detalleOrdenCompraRepository;
    private final OrdenCompraRepository ordenCompraRepository;

    @Transactional(readOnly=true)
    public DetalleOrdenCompraResponse obtenerPorId(Long id) {
        DetalleOrdenCompra detalle = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Detalle de orden de compra no encontrado con id: " + id));
        return this.mapToResponse(detalle);
    }

    @Transactional(readOnly=true)
    public List<DetalleOrdenCompraResponse> listarPorOrdenCompra(Long ordenCompraId) {
        return this.detalleOrdenCompraRepository.findByOrdenCompraId(ordenCompraId).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<DetalleOrdenCompraResponse> listarPendientesPorOrdenCompra(Long ordenCompraId) {
        return this.detalleOrdenCompraRepository.findDetallesPendientesByOrdenCompraId(ordenCompraId).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional
    public DetalleOrdenCompraResponse crear(Long ordenCompraId, DetalleOrdenCompraRequest request) {
        this.ordenCompraRepository.findById((Object)ordenCompraId).orElseThrow(() -> new IllegalArgumentException("Orden de compra no encontrada con id: " + ordenCompraId));
        DetalleOrdenCompra detalle = new DetalleOrdenCompra();
        detalle.setOrdenCompraId(ordenCompraId);
        detalle.setInsumoId(request.getInsumoId());
        detalle.setCantidadSolicitada(request.getCantidadSolicitada());
        detalle.setUnidadCompra(request.getUnidadCompra());
        detalle.setCostoUnitarioPactadoCentimos(request.getCostoUnitarioPactadoCentimos());
        long totalLinea = request.getCantidadSolicitada().multiply(BigDecimal.valueOf(request.getCostoUnitarioPactadoCentimos())).longValue();
        detalle.setTotalLineaCentimos(Long.valueOf(totalLinea));
        detalle.setCantidadRecibida(BigDecimal.ZERO);
        detalle.setRecibidoCompleto(Boolean.valueOf(false));
        DetalleOrdenCompra saved = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.save((Object)detalle);
        this.actualizarTotalOrden(ordenCompraId);
        return this.mapToResponse(saved);
    }

    @Transactional
    public DetalleOrdenCompraResponse actualizar(Long id, DetalleOrdenCompraRequest request) {
        DetalleOrdenCompra detalle = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Detalle de orden de compra no encontrado con id: " + id));
        detalle.setInsumoId(request.getInsumoId());
        detalle.setCantidadSolicitada(request.getCantidadSolicitada());
        detalle.setUnidadCompra(request.getUnidadCompra());
        detalle.setCostoUnitarioPactadoCentimos(request.getCostoUnitarioPactadoCentimos());
        long totalLinea = request.getCantidadSolicitada().multiply(BigDecimal.valueOf(request.getCostoUnitarioPactadoCentimos())).longValue();
        detalle.setTotalLineaCentimos(Long.valueOf(totalLinea));
        DetalleOrdenCompra updated = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.save((Object)detalle);
        this.actualizarTotalOrden(detalle.getOrdenCompraId());
        return this.mapToResponse(updated);
    }

    @Transactional
    public void eliminar(Long id) {
        DetalleOrdenCompra detalle = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Detalle de orden de compra no encontrado con id: " + id));
        Long ordenCompraId = detalle.getOrdenCompraId();
        this.detalleOrdenCompraRepository.deleteById((Object)id);
        this.actualizarTotalOrden(ordenCompraId);
    }

    @Transactional
    public DetalleOrdenCompraResponse actualizarRecepcion(Long id, Double cantidadRecibida, Boolean recibidoCompleto) {
        DetalleOrdenCompra detalle = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Detalle de orden de compra no encontrado con id: " + id));
        if (cantidadRecibida != null) {
            detalle.setCantidadRecibida(BigDecimal.valueOf(cantidadRecibida));
            if (detalle.getCantidadRecibida().compareTo(detalle.getCantidadSolicitada()) >= 0) {
                detalle.setRecibidoCompleto(Boolean.valueOf(true));
            }
        }
        if (recibidoCompleto != null) {
            detalle.setRecibidoCompleto(recibidoCompleto);
        }
        DetalleOrdenCompra updated = (DetalleOrdenCompra)this.detalleOrdenCompraRepository.save((Object)detalle);
        return this.mapToResponse(updated);
    }

    private void actualizarTotalOrden(Long ordenCompraId) {
        List detalles = this.detalleOrdenCompraRepository.findByOrdenCompraId(ordenCompraId);
        long total = detalles.stream().mapToLong(DetalleOrdenCompra::getTotalLineaCentimos).sum();
        OrdenCompra orden = (OrdenCompra)this.ordenCompraRepository.findById((Object)ordenCompraId).orElseThrow(() -> new IllegalArgumentException("Orden de compra no encontrada"));
        orden.setTotalCompraCentimos(Long.valueOf(total));
        this.ordenCompraRepository.save((Object)orden);
    }

    private DetalleOrdenCompraResponse mapToResponse(DetalleOrdenCompra detalle) {
        return DetalleOrdenCompraResponse.builder().id(detalle.getId()).ordenCompraId(detalle.getOrdenCompraId()).insumoId(detalle.getInsumoId()).cantidadSolicitada(detalle.getCantidadSolicitada()).unidadCompra(detalle.getUnidadCompra()).costoUnitarioPactadoCentimos(detalle.getCostoUnitarioPactadoCentimos()).totalLineaCentimos(detalle.getTotalLineaCentimos()).cantidadRecibida(detalle.getCantidadRecibida()).recibidoCompleto(detalle.getRecibidoCompleto()).build();
    }

    @Generated
    public DetalleOrdenCompraServiceImpl(DetalleOrdenCompraRepository detalleOrdenCompraRepository, OrdenCompraRepository ordenCompraRepository) {
        this.detalleOrdenCompraRepository = detalleOrdenCompraRepository;
        this.ordenCompraRepository = ordenCompraRepository;
    }
}

