/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.entity;

import com.dulcecontrol.bakery.features.admin.compras.entity.converter.UnidadMedidaConverter;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.UnidadMedida;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="insumos")
public class Insumo {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(nullable=false)
    private String nombre;
    @Column(name="codigo_interno", length=100)
    private String codigoInterno;
    @Convert(converter=UnidadMedidaConverter.class)
    @Column(name="unidad_base", nullable=false, columnDefinition="ENUM('unidad', 'kg', 'g', 'l', 'ml', 'paquete', 'saco', 'lata')")
    private UnidadMedida unidadBase;
    @Convert(converter=UnidadMedidaConverter.class)
    @Column(name="unidad_compra_habitual", nullable=false, columnDefinition="ENUM('unidad', 'kg', 'g', 'l', 'ml', 'paquete', 'saco', 'lata')")
    private UnidadMedida unidadCompraHabitual;
    @Column(name="factor_conversion", precision=12, scale=4)
    private BigDecimal factorConversion = BigDecimal.ONE;
    @Column(name="costo_promedio_unitario_centimos")
    private Long costoPromedioUnitarioCentimos = 0L;
    @Column(name="ultimo_precio_compra_centimos")
    private Long ultimoPrecioCompraCentimos;
    @Column(name="stock_actual_global", precision=12, scale=4)
    private BigDecimal stockActualGlobal = BigDecimal.ZERO;
    @Column(name="stock_minimo_global", precision=12, scale=4)
    private BigDecimal stockMinimoGlobal = BigDecimal.ZERO;
    @Column(nullable=false)
    private Boolean activo = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
        if (this.factorConversion == null) {
            this.factorConversion = BigDecimal.ONE;
        }
        if (this.costoPromedioUnitarioCentimos == null) {
            this.costoPromedioUnitarioCentimos = 0L;
        }
        if (this.stockActualGlobal == null) {
            this.stockActualGlobal = BigDecimal.ZERO;
        }
        if (this.stockMinimoGlobal == null) {
            this.stockMinimoGlobal = BigDecimal.ZERO;
        }
    }

    @Generated
    public Insumo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getCodigoInterno() {
        return this.codigoInterno;
    }

    @Generated
    public UnidadMedida getUnidadBase() {
        return this.unidadBase;
    }

    @Generated
    public UnidadMedida getUnidadCompraHabitual() {
        return this.unidadCompraHabitual;
    }

    @Generated
    public BigDecimal getFactorConversion() {
        return this.factorConversion;
    }

    @Generated
    public Long getCostoPromedioUnitarioCentimos() {
        return this.costoPromedioUnitarioCentimos;
    }

    @Generated
    public Long getUltimoPrecioCompraCentimos() {
        return this.ultimoPrecioCompraCentimos;
    }

    @Generated
    public BigDecimal getStockActualGlobal() {
        return this.stockActualGlobal;
    }

    @Generated
    public BigDecimal getStockMinimoGlobal() {
        return this.stockMinimoGlobal;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setCodigoInterno(String codigoInterno) {
        this.codigoInterno = codigoInterno;
    }

    @Generated
    public void setUnidadBase(UnidadMedida unidadBase) {
        this.unidadBase = unidadBase;
    }

    @Generated
    public void setUnidadCompraHabitual(UnidadMedida unidadCompraHabitual) {
        this.unidadCompraHabitual = unidadCompraHabitual;
    }

    @Generated
    public void setFactorConversion(BigDecimal factorConversion) {
        this.factorConversion = factorConversion;
    }

    @Generated
    public void setCostoPromedioUnitarioCentimos(Long costoPromedioUnitarioCentimos) {
        this.costoPromedioUnitarioCentimos = costoPromedioUnitarioCentimos;
    }

    @Generated
    public void setUltimoPrecioCompraCentimos(Long ultimoPrecioCompraCentimos) {
        this.ultimoPrecioCompraCentimos = ultimoPrecioCompraCentimos;
    }

    @Generated
    public void setStockActualGlobal(BigDecimal stockActualGlobal) {
        this.stockActualGlobal = stockActualGlobal;
    }

    @Generated
    public void setStockMinimoGlobal(BigDecimal stockMinimoGlobal) {
        this.stockMinimoGlobal = stockMinimoGlobal;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Insumo)) {
            return false;
        }
        Insumo other = (Insumo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$costoPromedioUnitarioCentimos = this.getCostoPromedioUnitarioCentimos();
        Long other$costoPromedioUnitarioCentimos = other.getCostoPromedioUnitarioCentimos();
        if (this$costoPromedioUnitarioCentimos == null ? other$costoPromedioUnitarioCentimos != null : !((Object)this$costoPromedioUnitarioCentimos).equals(other$costoPromedioUnitarioCentimos)) {
            return false;
        }
        Long this$ultimoPrecioCompraCentimos = this.getUltimoPrecioCompraCentimos();
        Long other$ultimoPrecioCompraCentimos = other.getUltimoPrecioCompraCentimos();
        if (this$ultimoPrecioCompraCentimos == null ? other$ultimoPrecioCompraCentimos != null : !((Object)this$ultimoPrecioCompraCentimos).equals(other$ultimoPrecioCompraCentimos)) {
            return false;
        }
        Boolean this$activo = this.getActivo();
        Boolean other$activo = other.getActivo();
        if (this$activo == null ? other$activo != null : !((Object)this$activo).equals(other$activo)) {
            return false;
        }
        String this$nombre = this.getNombre();
        String other$nombre = other.getNombre();
        if (this$nombre == null ? other$nombre != null : !this$nombre.equals(other$nombre)) {
            return false;
        }
        String this$codigoInterno = this.getCodigoInterno();
        String other$codigoInterno = other.getCodigoInterno();
        if (this$codigoInterno == null ? other$codigoInterno != null : !this$codigoInterno.equals(other$codigoInterno)) {
            return false;
        }
        UnidadMedida this$unidadBase = this.getUnidadBase();
        UnidadMedida other$unidadBase = other.getUnidadBase();
        if (this$unidadBase == null ? other$unidadBase != null : !this$unidadBase.equals(other$unidadBase)) {
            return false;
        }
        UnidadMedida this$unidadCompraHabitual = this.getUnidadCompraHabitual();
        UnidadMedida other$unidadCompraHabitual = other.getUnidadCompraHabitual();
        if (this$unidadCompraHabitual == null ? other$unidadCompraHabitual != null : !this$unidadCompraHabitual.equals(other$unidadCompraHabitual)) {
            return false;
        }
        BigDecimal this$factorConversion = this.getFactorConversion();
        BigDecimal other$factorConversion = other.getFactorConversion();
        if (this$factorConversion == null ? other$factorConversion != null : !((Object)this$factorConversion).equals(other$factorConversion)) {
            return false;
        }
        BigDecimal this$stockActualGlobal = this.getStockActualGlobal();
        BigDecimal other$stockActualGlobal = other.getStockActualGlobal();
        if (this$stockActualGlobal == null ? other$stockActualGlobal != null : !((Object)this$stockActualGlobal).equals(other$stockActualGlobal)) {
            return false;
        }
        BigDecimal this$stockMinimoGlobal = this.getStockMinimoGlobal();
        BigDecimal other$stockMinimoGlobal = other.getStockMinimoGlobal();
        if (this$stockMinimoGlobal == null ? other$stockMinimoGlobal != null : !((Object)this$stockMinimoGlobal).equals(other$stockMinimoGlobal)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        return !(this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Insumo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $costoPromedioUnitarioCentimos = this.getCostoPromedioUnitarioCentimos();
        result = result * 59 + ($costoPromedioUnitarioCentimos == null ? 43 : ((Object)$costoPromedioUnitarioCentimos).hashCode());
        Long $ultimoPrecioCompraCentimos = this.getUltimoPrecioCompraCentimos();
        result = result * 59 + ($ultimoPrecioCompraCentimos == null ? 43 : ((Object)$ultimoPrecioCompraCentimos).hashCode());
        Boolean $activo = this.getActivo();
        result = result * 59 + ($activo == null ? 43 : ((Object)$activo).hashCode());
        String $nombre = this.getNombre();
        result = result * 59 + ($nombre == null ? 43 : $nombre.hashCode());
        String $codigoInterno = this.getCodigoInterno();
        result = result * 59 + ($codigoInterno == null ? 43 : $codigoInterno.hashCode());
        UnidadMedida $unidadBase = this.getUnidadBase();
        result = result * 59 + ($unidadBase == null ? 43 : $unidadBase.hashCode());
        UnidadMedida $unidadCompraHabitual = this.getUnidadCompraHabitual();
        result = result * 59 + ($unidadCompraHabitual == null ? 43 : $unidadCompraHabitual.hashCode());
        BigDecimal $factorConversion = this.getFactorConversion();
        result = result * 59 + ($factorConversion == null ? 43 : ((Object)$factorConversion).hashCode());
        BigDecimal $stockActualGlobal = this.getStockActualGlobal();
        result = result * 59 + ($stockActualGlobal == null ? 43 : ((Object)$stockActualGlobal).hashCode());
        BigDecimal $stockMinimoGlobal = this.getStockMinimoGlobal();
        result = result * 59 + ($stockMinimoGlobal == null ? 43 : ((Object)$stockMinimoGlobal).hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Insumo(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", nombre=" + this.getNombre() + ", codigoInterno=" + this.getCodigoInterno() + ", unidadBase=" + String.valueOf(this.getUnidadBase()) + ", unidadCompraHabitual=" + String.valueOf(this.getUnidadCompraHabitual()) + ", factorConversion=" + String.valueOf(this.getFactorConversion()) + ", costoPromedioUnitarioCentimos=" + this.getCostoPromedioUnitarioCentimos() + ", ultimoPrecioCompraCentimos=" + this.getUltimoPrecioCompraCentimos() + ", stockActualGlobal=" + String.valueOf(this.getStockActualGlobal()) + ", stockMinimoGlobal=" + String.valueOf(this.getStockMinimoGlobal()) + ", activo=" + this.getActivo() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ")";
    }
}

