/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.controller;

import com.dulcecontrol.bakery.features.admin.compras.dto.PagoOrdenCompraRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.PagoOrdenCompraResponse;
import com.dulcecontrol.bakery.features.admin.compras.service.IPagoOrdenCompraService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/compras/pagos"})
@Validated
public class PagoOrdenCompraController {
    private final IPagoOrdenCompraService pagoOrdenCompraService;

    @PostMapping
    public ResponseEntity<PagoOrdenCompraResponse> registrarPago(@PathVariable Long tiendaId, @Valid @RequestBody PagoOrdenCompraRequest request) {
        PagoOrdenCompraResponse response = this.pagoOrdenCompraService.registrarPago(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping(value={"/orden/{ordenCompraId}"})
    public ResponseEntity<List<PagoOrdenCompraResponse>> obtenerHistorialPagos(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId) {
        List historial = this.pagoOrdenCompraService.obtenerHistorialPagos(ordenCompraId);
        return ResponseEntity.ok((Object)historial);
    }

    @GetMapping(value={"/{pagoId}"})
    public ResponseEntity<PagoOrdenCompraResponse> obtenerPagoPorId(@PathVariable Long tiendaId, @PathVariable Long pagoId) {
        PagoOrdenCompraResponse response = this.pagoOrdenCompraService.obtenerPagoPorId(pagoId);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public PagoOrdenCompraController(IPagoOrdenCompraService pagoOrdenCompraService) {
        this.pagoOrdenCompraService = pagoOrdenCompraService;
    }
}

