/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.controller;

import com.dulcecontrol.bakery.features.admin.compras.dto.InsumoCreateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.InsumoResponse;
import com.dulcecontrol.bakery.features.admin.compras.dto.InsumoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.compras.service.IInsumoService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/compras/insumos"})
@Validated
public class InsumoController {
    private final IInsumoService insumoService;

    @GetMapping
    public ResponseEntity<List<InsumoResponse>> listar(@PathVariable Long tiendaId, @RequestParam(required=false) Boolean soloActivos, @RequestParam(required=false) Boolean stockBajo) {
        if (Boolean.TRUE.equals(stockBajo)) {
            return ResponseEntity.ok((Object)this.insumoService.listarConStockBajo(tiendaId));
        }
        if (Boolean.TRUE.equals(soloActivos)) {
            return ResponseEntity.ok((Object)this.insumoService.listarActivos(tiendaId));
        }
        return ResponseEntity.ok((Object)this.insumoService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{insumoId}"})
    public ResponseEntity<InsumoResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long insumoId) {
        return ResponseEntity.ok((Object)this.insumoService.obtenerPorId(tiendaId, insumoId));
    }

    @PostMapping
    public ResponseEntity<InsumoResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody InsumoCreateRequest request) {
        request.setTiendaId(tiendaId);
        InsumoResponse response = this.insumoService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{insumoId}"})
    public ResponseEntity<InsumoResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long insumoId, @Valid @RequestBody InsumoUpdateRequest request) {
        InsumoResponse response = this.insumoService.actualizar(tiendaId, insumoId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{insumoId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long insumoId) {
        this.insumoService.eliminar(tiendaId, insumoId);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{insumoId}/desactivar"})
    public ResponseEntity<Void> desactivar(@PathVariable Long tiendaId, @PathVariable Long insumoId) {
        this.insumoService.desactivar(tiendaId, insumoId);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{insumoId}/reactivar"})
    public ResponseEntity<Void> reactivar(@PathVariable Long tiendaId, @PathVariable Long insumoId) {
        this.insumoService.reactivar(tiendaId, insumoId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public InsumoController(IInsumoService insumoService) {
        this.insumoService = insumoService;
    }
}

