/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.controller;

import com.dulcecontrol.bakery.features.admin.compras.dto.DetalleOrdenCompraRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.DetalleOrdenCompraResponse;
import com.dulcecontrol.bakery.features.admin.compras.service.IDetalleOrdenCompraService;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/compras/ordenes/{ordenCompraId}/detalles"})
public class DetalleOrdenCompraController {
    private final IDetalleOrdenCompraService detalleOrdenCompraService;

    @GetMapping
    public ResponseEntity<List<DetalleOrdenCompraResponse>> listar(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId, @RequestParam(required=false) Boolean soloPendientes) {
        if (Boolean.TRUE.equals(soloPendientes)) {
            return ResponseEntity.ok((Object)this.detalleOrdenCompraService.listarPendientesPorOrdenCompra(ordenCompraId));
        }
        return ResponseEntity.ok((Object)this.detalleOrdenCompraService.listarPorOrdenCompra(ordenCompraId));
    }

    @GetMapping(value={"/{detalleId}"})
    public ResponseEntity<DetalleOrdenCompraResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId, @PathVariable Long detalleId) {
        return ResponseEntity.ok((Object)this.detalleOrdenCompraService.obtenerPorId(detalleId));
    }

    @PostMapping
    public ResponseEntity<DetalleOrdenCompraResponse> crear(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId, @Valid @RequestBody DetalleOrdenCompraRequest request) {
        DetalleOrdenCompraResponse response = this.detalleOrdenCompraService.crear(ordenCompraId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{detalleId}"})
    public ResponseEntity<DetalleOrdenCompraResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId, @PathVariable Long detalleId, @Valid @RequestBody DetalleOrdenCompraRequest request) {
        DetalleOrdenCompraResponse response = this.detalleOrdenCompraService.actualizar(detalleId, request);
        return ResponseEntity.ok((Object)response);
    }

    @PatchMapping(value={"/{detalleId}/recepcion"})
    public ResponseEntity<DetalleOrdenCompraResponse> actualizarRecepcion(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId, @PathVariable Long detalleId, @RequestBody Map<String, Object> payload) {
        Double cantidadRecibida = payload.containsKey("cantidadRecibida") ? Double.valueOf(((Number)payload.get("cantidadRecibida")).doubleValue()) : null;
        Boolean recibidoCompleto = payload.containsKey("recibidoCompleto") ? (Boolean)payload.get("recibidoCompleto") : null;
        DetalleOrdenCompraResponse response = this.detalleOrdenCompraService.actualizarRecepcion(detalleId, cantidadRecibida, recibidoCompleto);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{detalleId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long ordenCompraId, @PathVariable Long detalleId) {
        this.detalleOrdenCompraService.eliminar(detalleId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public DetalleOrdenCompraController(IDetalleOrdenCompraService detalleOrdenCompraService) {
        this.detalleOrdenCompraService = detalleOrdenCompraService;
    }
}

