/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.clientes.service.impl;

import com.dulcecontrol.bakery.features.admin.clientes.dto.DireccionClienteCreateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.dto.DireccionClienteResponse;
import com.dulcecontrol.bakery.features.admin.clientes.dto.DireccionClienteUpdateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.entity.DireccionCliente;
import com.dulcecontrol.bakery.features.admin.clientes.repository.ClienteRepository;
import com.dulcecontrol.bakery.features.admin.clientes.repository.DireccionClienteRepository;
import com.dulcecontrol.bakery.features.admin.clientes.service.IDireccionClienteAdminService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DireccionClienteAdminService
implements IDireccionClienteAdminService {
    private final DireccionClienteRepository direccionClienteRepository;
    private final ClienteRepository clienteRepository;

    @Transactional(readOnly=true)
    public List<DireccionClienteResponse> listarPorCliente(Long tiendaId, Long clienteId) {
        this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        return this.direccionClienteRepository.findByClienteId(clienteId).stream().sorted(Comparator.comparing(DireccionCliente::getEtiqueta, Comparator.nullsLast(String::compareTo))).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public DireccionClienteResponse obtenerPorId(Long tiendaId, Long clienteId, Long direccionId) {
        this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        DireccionCliente direccion = (DireccionCliente)this.direccionClienteRepository.findByIdAndClienteId(direccionId, clienteId).orElseThrow(() -> new ResourceNotFoundException("Direcci\u00f3n no encontrada"));
        return this.toResponse(direccion);
    }

    @Transactional
    public DireccionClienteResponse crear(Long tiendaId, Long clienteId, DireccionClienteCreateRequest request) {
        this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        DireccionCliente direccion = new DireccionCliente();
        direccion.setClienteId(clienteId);
        direccion.setEtiqueta(request.getEtiqueta());
        direccion.setDireccionCompleta(request.getDireccionCompleta());
        direccion.setReferencia(request.getReferencia());
        direccion.setDistritoId(request.getDistritoId());
        direccion.setCodigoPostal(request.getCodigoPostal());
        direccion.setEsFiscal(Boolean.valueOf(request.getEsFiscal() != null ? request.getEsFiscal() : false));
        direccion.setEsEntrega(Boolean.valueOf(request.getEsEntrega() != null ? request.getEsEntrega() : false));
        DireccionCliente saved = (DireccionCliente)this.direccionClienteRepository.save((Object)direccion);
        return this.toResponse(saved);
    }

    @Transactional
    public DireccionClienteResponse actualizar(Long tiendaId, Long clienteId, Long direccionId, DireccionClienteUpdateRequest request) {
        this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        DireccionCliente direccion = (DireccionCliente)this.direccionClienteRepository.findByIdAndClienteId(direccionId, clienteId).orElseThrow(() -> new ResourceNotFoundException("Direcci\u00f3n no encontrada"));
        direccion.setEtiqueta(request.getEtiqueta());
        direccion.setDireccionCompleta(request.getDireccionCompleta());
        direccion.setReferencia(request.getReferencia());
        direccion.setDistritoId(request.getDistritoId());
        direccion.setCodigoPostal(request.getCodigoPostal());
        direccion.setEsFiscal(request.getEsFiscal());
        direccion.setEsEntrega(request.getEsEntrega());
        DireccionCliente saved = (DireccionCliente)this.direccionClienteRepository.save((Object)direccion);
        return this.toResponse(saved);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long clienteId, Long direccionId) {
        this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        DireccionCliente direccion = (DireccionCliente)this.direccionClienteRepository.findByIdAndClienteId(direccionId, clienteId).orElseThrow(() -> new ResourceNotFoundException("Direcci\u00f3n no encontrada"));
        this.direccionClienteRepository.delete((Object)direccion);
    }

    private DireccionClienteResponse toResponse(DireccionCliente direccion) {
        return DireccionClienteResponse.builder().id(direccion.getId()).clienteId(direccion.getClienteId()).etiqueta(direccion.getEtiqueta()).direccionCompleta(direccion.getDireccionCompleta()).referencia(direccion.getReferencia()).distritoId(direccion.getDistritoId()).codigoPostal(direccion.getCodigoPostal()).esFiscal(direccion.getEsFiscal()).esEntrega(direccion.getEsEntrega()).creadoEn(direccion.getCreadoEn()).build();
    }

    @Generated
    public DireccionClienteAdminService(DireccionClienteRepository direccionClienteRepository, ClienteRepository clienteRepository) {
        this.direccionClienteRepository = direccionClienteRepository;
        this.clienteRepository = clienteRepository;
    }
}

