/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.clientes.service.impl;

import com.dulcecontrol.bakery.features.admin.clientes.dto.ClienteCreateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.dto.ClienteResponse;
import com.dulcecontrol.bakery.features.admin.clientes.dto.ClienteUpdateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.entity.Cliente;
import com.dulcecontrol.bakery.features.admin.clientes.entity.DireccionCliente;
import com.dulcecontrol.bakery.features.admin.clientes.repository.ClienteRepository;
import com.dulcecontrol.bakery.features.admin.clientes.repository.DireccionClienteRepository;
import com.dulcecontrol.bakery.features.admin.clientes.service.IClienteAdminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClienteAdminService
implements IClienteAdminService {
    private final ClienteRepository clienteRepository;
    private final DireccionClienteRepository direccionClienteRepository;

    @Transactional(readOnly=true)
    public List<ClienteResponse> listarPorTienda(Long tiendaId) {
        return this.clienteRepository.findByTiendaId(tiendaId).stream().sorted(Comparator.comparing(Cliente::getNombreDoc)).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<ClienteResponse> buscarPorTiendaYTexto(Long tiendaId, String busqueda) {
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.listarPorTienda(tiendaId);
        }
        return this.clienteRepository.buscarPorTiendaYTexto(tiendaId, busqueda.trim()).stream().sorted(Comparator.comparing(Cliente::getNombreDoc)).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public ClienteResponse obtenerPorId(Long tiendaId, Long clienteId) {
        Cliente cliente = (Cliente)this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        return this.toResponse(cliente);
    }

    @Transactional
    public ClienteResponse crear(Long tiendaId, ClienteCreateRequest request) {
        if (request.getTipoDocumento() != null && request.getNumeroDoc() != null && this.clienteRepository.existsByTiendaIdAndTipoDocAndNumeroDoc(tiendaId, request.getTipoDocumento(), request.getNumeroDoc())) {
            throw new BadRequestException("Ya existe un cliente con el mismo tipo y n\u00famero de documento");
        }
        if (request.getEmail() != null && this.clienteRepository.existsByTiendaIdAndEmail(tiendaId, request.getEmail())) {
            throw new BadRequestException("Ya existe un cliente con el mismo email");
        }
        Cliente cliente = new Cliente();
        cliente.setTiendaId(tiendaId);
        cliente.setTipoDoc(request.getTipoDocumento());
        cliente.setNumeroDoc(request.getNumeroDoc());
        cliente.setNombreDoc(request.getNombreDoc());
        cliente.setEmail(request.getEmail());
        cliente.setTelefono(request.getTelefono());
        cliente.setEsUsuarioVirtual(Boolean.valueOf(request.getEsUsuarioVirtual() != null ? request.getEsUsuarioVirtual() : false));
        cliente.setHashContrasena(request.getHashContrasena());
        cliente.setNotas(request.getNotas());
        Cliente saved = (Cliente)this.clienteRepository.save((Object)cliente);
        if (request.getDireccionCompleta() != null && !request.getDireccionCompleta().trim().isEmpty()) {
            DireccionCliente direccion = new DireccionCliente();
            direccion.setClienteId(saved.getId());
            direccion.setEtiqueta(request.getDireccionEtiqueta());
            direccion.setDireccionCompleta(request.getDireccionCompleta());
            direccion.setReferencia(request.getDireccionReferencia());
            direccion.setDistritoId(request.getDireccionDistritoId());
            direccion.setCodigoPostal(request.getDireccionCodigoPostal());
            direccion.setEsFiscal(Boolean.valueOf(request.getDireccionEsFiscal() != null ? request.getDireccionEsFiscal() : false));
            direccion.setEsEntrega(Boolean.valueOf(request.getDireccionEsEntrega() != null ? request.getDireccionEsEntrega() : false));
            this.direccionClienteRepository.save((Object)direccion);
        }
        return this.toResponse(saved);
    }

    @Transactional
    public ClienteResponse actualizar(Long tiendaId, Long clienteId, ClienteUpdateRequest request) {
        Cliente cliente = (Cliente)this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        if (request.getTipoDocumento() != null && request.getNumeroDoc() != null && this.clienteRepository.existsByTiendaIdAndTipoDocAndNumeroDocAndIdNot(tiendaId, request.getTipoDocumento(), request.getNumeroDoc(), clienteId)) {
            throw new BadRequestException("Ya existe otro cliente con el mismo tipo y n\u00famero de documento");
        }
        if (request.getEmail() != null && this.clienteRepository.existsByTiendaIdAndEmailAndIdNot(tiendaId, request.getEmail(), clienteId)) {
            throw new BadRequestException("Ya existe otro cliente con el mismo email");
        }
        cliente.setTipoDoc(request.getTipoDocumento());
        cliente.setNumeroDoc(request.getNumeroDoc());
        cliente.setNombreDoc(request.getNombreDoc());
        cliente.setEmail(request.getEmail());
        cliente.setTelefono(request.getTelefono());
        cliente.setEsUsuarioVirtual(request.getEsUsuarioVirtual());
        cliente.setHashContrasena(request.getHashContrasena());
        cliente.setNotas(request.getNotas());
        if (request.getActivo() != null) {
            cliente.setActivo(request.getActivo());
        }
        Cliente saved = (Cliente)this.clienteRepository.save((Object)cliente);
        if (request.getDireccionCompleta() != null && !request.getDireccionCompleta().trim().isEmpty()) {
            List direccionesExistentes = this.direccionClienteRepository.findByClienteId(clienteId);
            if (!direccionesExistentes.isEmpty()) {
                DireccionCliente direccion = (DireccionCliente)direccionesExistentes.get(0);
                direccion.setEtiqueta(request.getDireccionEtiqueta());
                direccion.setDireccionCompleta(request.getDireccionCompleta());
                direccion.setReferencia(request.getDireccionReferencia());
                direccion.setDistritoId(request.getDireccionDistritoId());
                direccion.setCodigoPostal(request.getDireccionCodigoPostal());
                direccion.setEsFiscal(Boolean.valueOf(request.getDireccionEsFiscal() != null ? request.getDireccionEsFiscal() : false));
                direccion.setEsEntrega(Boolean.valueOf(request.getDireccionEsEntrega() != null ? request.getDireccionEsEntrega() : false));
                this.direccionClienteRepository.save((Object)direccion);
            } else {
                DireccionCliente direccion = new DireccionCliente();
                direccion.setClienteId(saved.getId());
                direccion.setEtiqueta(request.getDireccionEtiqueta());
                direccion.setDireccionCompleta(request.getDireccionCompleta());
                direccion.setReferencia(request.getDireccionReferencia());
                direccion.setDistritoId(request.getDireccionDistritoId());
                direccion.setCodigoPostal(request.getDireccionCodigoPostal());
                direccion.setEsFiscal(Boolean.valueOf(request.getDireccionEsFiscal() != null ? request.getDireccionEsFiscal() : false));
                direccion.setEsEntrega(Boolean.valueOf(request.getDireccionEsEntrega() != null ? request.getDireccionEsEntrega() : false));
                this.direccionClienteRepository.save((Object)direccion);
            }
        }
        return this.toResponse(saved);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long clienteId) {
        Cliente cliente = (Cliente)this.clienteRepository.findByIdAndTiendaId(clienteId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        this.clienteRepository.delete((Object)cliente);
    }

    private ClienteResponse toResponse(Cliente cliente) {
        return ClienteResponse.builder().id(cliente.getId()).tiendaId(cliente.getTiendaId()).tipoDoc(cliente.getTipoDoc()).numeroDoc(cliente.getNumeroDoc()).nombreDoc(cliente.getNombreDoc()).email(cliente.getEmail()).telefono(cliente.getTelefono()).esUsuarioVirtual(cliente.getEsUsuarioVirtual()).notas(cliente.getNotas()).activo(cliente.getActivo()).creadoEn(cliente.getCreadoEn()).actualizadoEn(cliente.getActualizadoEn()).build();
    }

    @Generated
    public ClienteAdminService(ClienteRepository clienteRepository, DireccionClienteRepository direccionClienteRepository) {
        this.clienteRepository = clienteRepository;
        this.direccionClienteRepository = direccionClienteRepository;
    }
}

