/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.clientes.entity;

import com.dulcecontrol.bakery.features.admin.clientes.entity.enums.TipoDocumento;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="clientes", uniqueConstraints={@UniqueConstraint(columnNames={"tienda_id", "tipo_doc", "numero_doc"}), @UniqueConstraint(columnNames={"tienda_id", "email"})})
@SQLDelete(sql="UPDATE clientes SET activo = false WHERE id = ?")
@SQLRestriction(value="activo = true")
public class Cliente {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="tipo_doc", columnDefinition="ENUM('DNI', 'RUC')")
    private TipoDocumento tipoDoc;
    @Column(name="numero_doc", length=20)
    private String numeroDoc;
    @Column(name="nombre_doc", nullable=false)
    private String nombreDoc;
    @Column(length=255)
    private String email;
    @Column(length=50)
    private String telefono;
    @Column(name="es_usuario_virtual", nullable=false)
    private Boolean esUsuarioVirtual = false;
    @Column(name="hash_contrasena")
    private String hashContrasena;
    @Column(columnDefinition="TEXT")
    private String notas;
    @Column(nullable=false)
    private Boolean activo = true;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    protected void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.activo == null) {
            this.activo = true;
        }
        if (this.esUsuarioVirtual == null) {
            this.esUsuarioVirtual = false;
        }
    }

    @PreUpdate
    protected void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Cliente() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public TipoDocumento getTipoDoc() {
        return this.tipoDoc;
    }

    @Generated
    public String getNumeroDoc() {
        return this.numeroDoc;
    }

    @Generated
    public String getNombreDoc() {
        return this.nombreDoc;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public Boolean getEsUsuarioVirtual() {
        return this.esUsuarioVirtual;
    }

    @Generated
    public String getHashContrasena() {
        return this.hashContrasena;
    }

    @Generated
    public String getNotas() {
        return this.notas;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setTipoDoc(TipoDocumento tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Generated
    public void setNumeroDoc(String numeroDoc) {
        this.numeroDoc = numeroDoc;
    }

    @Generated
    public void setNombreDoc(String nombreDoc) {
        this.nombreDoc = nombreDoc;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setEsUsuarioVirtual(Boolean esUsuarioVirtual) {
        this.esUsuarioVirtual = esUsuarioVirtual;
    }

    @Generated
    public void setHashContrasena(String hashContrasena) {
        this.hashContrasena = hashContrasena;
    }

    @Generated
    public void setNotas(String notas) {
        this.notas = notas;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cliente)) {
            return false;
        }
        Cliente other = (Cliente)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Boolean this$esUsuarioVirtual = this.getEsUsuarioVirtual();
        Boolean other$esUsuarioVirtual = other.getEsUsuarioVirtual();
        if (this$esUsuarioVirtual == null ? other$esUsuarioVirtual != null : !((Object)this$esUsuarioVirtual).equals(other$esUsuarioVirtual)) {
            return false;
        }
        Boolean this$activo = this.getActivo();
        Boolean other$activo = other.getActivo();
        if (this$activo == null ? other$activo != null : !((Object)this$activo).equals(other$activo)) {
            return false;
        }
        TipoDocumento this$tipoDoc = this.getTipoDoc();
        TipoDocumento other$tipoDoc = other.getTipoDoc();
        if (this$tipoDoc == null ? other$tipoDoc != null : !this$tipoDoc.equals(other$tipoDoc)) {
            return false;
        }
        String this$numeroDoc = this.getNumeroDoc();
        String other$numeroDoc = other.getNumeroDoc();
        if (this$numeroDoc == null ? other$numeroDoc != null : !this$numeroDoc.equals(other$numeroDoc)) {
            return false;
        }
        String this$nombreDoc = this.getNombreDoc();
        String other$nombreDoc = other.getNombreDoc();
        if (this$nombreDoc == null ? other$nombreDoc != null : !this$nombreDoc.equals(other$nombreDoc)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        String this$hashContrasena = this.getHashContrasena();
        String other$hashContrasena = other.getHashContrasena();
        if (this$hashContrasena == null ? other$hashContrasena != null : !this$hashContrasena.equals(other$hashContrasena)) {
            return false;
        }
        String this$notas = this.getNotas();
        String other$notas = other.getNotas();
        if (this$notas == null ? other$notas != null : !this$notas.equals(other$notas)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        return !(this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cliente;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Boolean $esUsuarioVirtual = this.getEsUsuarioVirtual();
        result = result * 59 + ($esUsuarioVirtual == null ? 43 : ((Object)$esUsuarioVirtual).hashCode());
        Boolean $activo = this.getActivo();
        result = result * 59 + ($activo == null ? 43 : ((Object)$activo).hashCode());
        TipoDocumento $tipoDoc = this.getTipoDoc();
        result = result * 59 + ($tipoDoc == null ? 43 : $tipoDoc.hashCode());
        String $numeroDoc = this.getNumeroDoc();
        result = result * 59 + ($numeroDoc == null ? 43 : $numeroDoc.hashCode());
        String $nombreDoc = this.getNombreDoc();
        result = result * 59 + ($nombreDoc == null ? 43 : $nombreDoc.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        String $hashContrasena = this.getHashContrasena();
        result = result * 59 + ($hashContrasena == null ? 43 : $hashContrasena.hashCode());
        String $notas = this.getNotas();
        result = result * 59 + ($notas == null ? 43 : $notas.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Cliente(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", tipoDoc=" + String.valueOf(this.getTipoDoc()) + ", numeroDoc=" + this.getNumeroDoc() + ", nombreDoc=" + this.getNombreDoc() + ", email=" + this.getEmail() + ", telefono=" + this.getTelefono() + ", esUsuarioVirtual=" + this.getEsUsuarioVirtual() + ", hashContrasena=" + this.getHashContrasena() + ", notas=" + this.getNotas() + ", activo=" + this.getActivo() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ")";
    }
}

