/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.clientes.controller;

import com.dulcecontrol.bakery.features.admin.clientes.dto.DireccionClienteCreateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.dto.DireccionClienteResponse;
import com.dulcecontrol.bakery.features.admin.clientes.dto.DireccionClienteUpdateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.service.IDireccionClienteAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/clientes/{clienteId}/direcciones"})
@Validated
public class DireccionClienteAdminController {
    private final IDireccionClienteAdminService direccionClienteAdminService;

    @GetMapping(value={"/{direccionId}"})
    public ResponseEntity<DireccionClienteResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long clienteId, @PathVariable Long direccionId) {
        return ResponseEntity.ok((Object)this.direccionClienteAdminService.obtenerPorId(tiendaId, clienteId, direccionId));
    }

    @PutMapping(value={"/{direccionId}"})
    public ResponseEntity<DireccionClienteResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long clienteId, @PathVariable Long direccionId, @Valid @RequestBody DireccionClienteUpdateRequest request) {
        DireccionClienteResponse response = this.direccionClienteAdminService.actualizar(tiendaId, clienteId, direccionId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{direccionId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long clienteId, @PathVariable Long direccionId) {
        this.direccionClienteAdminService.eliminar(tiendaId, clienteId, direccionId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping
    public ResponseEntity<List<DireccionClienteResponse>> listar(@PathVariable Long tiendaId, @PathVariable Long clienteId) {
        return ResponseEntity.ok((Object)this.direccionClienteAdminService.listarPorCliente(tiendaId, clienteId));
    }

    @PostMapping
    public ResponseEntity<DireccionClienteResponse> crear(@PathVariable Long tiendaId, @PathVariable Long clienteId, @Valid @RequestBody DireccionClienteCreateRequest request) {
        DireccionClienteResponse response = this.direccionClienteAdminService.crear(tiendaId, clienteId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @Generated
    public DireccionClienteAdminController(IDireccionClienteAdminService direccionClienteAdminService) {
        this.direccionClienteAdminService = direccionClienteAdminService;
    }
}

