/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.catalogo.service.impl;

import com.dulcecontrol.bakery.features.admin.catalogo.dto.ProductoCreateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.ProductoResponse;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.ProductoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.Categoria;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.enums.TipoProducto;
import com.dulcecontrol.bakery.features.admin.catalogo.service.IProductoAdminService;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioProductoRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.CategoriaRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Sede;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.SedeRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductoAdminService
implements IProductoAdminService {
    private final ProductoRepository productoRepository;
    private final CategoriaRepository categoriaRepository;
    private final SedeRepository sedeRepository;
    private final InventarioProductoRepository inventarioProductoRepository;

    @Transactional(readOnly=true)
    public List<ProductoResponse> listar(Long tiendaId, Long categoriaId) {
        List productos;
        if (categoriaId != null) {
            this.validarCategoriaPerteneceATienda(tiendaId, categoriaId);
            productos = this.productoRepository.findByTiendaIdAndCategoriaIdOrderByNombreAsc(tiendaId, categoriaId);
        } else {
            productos = this.productoRepository.findByTiendaIdOrderByNombreAsc(tiendaId);
        }
        return productos.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public ProductoResponse obtener(Long tiendaId, Long productoId) {
        Producto producto = (Producto)this.productoRepository.findByIdAndTiendaId(productoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Producto no encontrado"));
        return this.toResponse(producto);
    }

    @Transactional
    public ProductoResponse crear(Long tiendaId, ProductoCreateRequest request) {
        this.validarDuplicadosAlCrear(tiendaId, request.getSku(), request.getSlug());
        Long categoriaId = this.resolverCategoriaId(tiendaId, request.getCategoriaId());
        Producto producto = new Producto();
        producto.setTiendaId(tiendaId);
        producto.setCategoriaId(categoriaId);
        producto.setNombre(request.getNombre());
        producto.setSlug(request.getSlug());
        producto.setSku(request.getSku());
        producto.setDescripcion(request.getDescripcion());
        producto.setTipo(request.getTipo());
        producto.setEsPersonalizable(request.getEsPersonalizable() != null ? request.getEsPersonalizable() : Boolean.FALSE);
        producto.setPrecioBaseCentimos(request.getPrecioBaseCentimos());
        producto.setPrecioOfertaCentimos(request.getPrecioOfertaCentimos());
        producto.setVisibleEnPos(request.getVisibleEnPos() != null ? request.getVisibleEnPos() : Boolean.TRUE);
        producto.setVisibleEnStorefront(request.getVisibleEnStorefront() != null ? request.getVisibleEnStorefront() : Boolean.TRUE);
        producto.setDestacadoStorefront(request.getDestacadoStorefront() != null ? request.getDestacadoStorefront() : Boolean.FALSE);
        producto.setUrlImagenPrincipal(request.getUrlImagenPrincipal());
        producto.setImagenesGaleria(this.cloneList(request.getImagenesGaleria()));
        producto.setAtributos(this.cloneMap(request.getAtributos()));
        producto.setActivo(request.getActivo() == null ? Boolean.TRUE : request.getActivo());
        Producto guardado = (Producto)this.productoRepository.save((Object)producto);
        if (request.getTipo() != TipoProducto.SERVICIO) {
            this.crearInventarioPorSedes(tiendaId, guardado.getId());
        }
        return this.toResponse(guardado);
    }

    private void crearInventarioPorSedes(Long tiendaId, Long productoId) {
        List<Sede> sedes = this.sedeRepository.findByTiendaId(tiendaId).stream().filter(sede -> Boolean.TRUE.equals(sede.getActivo())).toList();
        if (sedes.isEmpty()) {
            return;
        }
        List<InventarioProducto> nuevos = sedes.stream().filter(sede -> !this.inventarioProductoRepository.existsBySedeIdAndProductoId(sede.getId(), productoId)).map(sede -> {
            InventarioProducto inv = new InventarioProducto();
            inv.setTiendaId(tiendaId);
            inv.setSedeId(sede.getId());
            inv.setProductoId(productoId);
            inv.setCantidadActual(Integer.valueOf(0));
            inv.setUbicacionFisica(null);
            return inv;
        }).toList();
        if (!nuevos.isEmpty()) {
            this.inventarioProductoRepository.saveAll(nuevos);
        }
    }

    @Transactional
    public ProductoResponse actualizar(Long tiendaId, Long productoId, ProductoUpdateRequest request) {
        Producto producto = (Producto)this.productoRepository.findByIdAndTiendaId(productoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Producto no encontrado"));
        if (this.productoRepository.existsByTiendaIdAndSkuIgnoreCaseAndIdNot(tiendaId, request.getSku(), productoId)) {
            throw new BadRequestException("El SKU ya est\u00e1 registrado para esta tienda");
        }
        if (this.productoRepository.existsByTiendaIdAndSlugIgnoreCaseAndIdNot(tiendaId, request.getSlug(), productoId)) {
            throw new BadRequestException("El slug ya est\u00e1 registrado para esta tienda");
        }
        Long categoriaId = this.resolverCategoriaId(tiendaId, request.getCategoriaId());
        producto.setCategoriaId(categoriaId);
        producto.setNombre(request.getNombre());
        producto.setSlug(request.getSlug());
        producto.setSku(request.getSku());
        producto.setDescripcion(request.getDescripcion());
        producto.setTipo(request.getTipo());
        producto.setEsPersonalizable(request.getEsPersonalizable() != null ? request.getEsPersonalizable() : Boolean.FALSE);
        producto.setPrecioBaseCentimos(request.getPrecioBaseCentimos());
        producto.setPrecioOfertaCentimos(request.getPrecioOfertaCentimos());
        producto.setVisibleEnPos(request.getVisibleEnPos() != null ? request.getVisibleEnPos() : Boolean.TRUE);
        producto.setVisibleEnStorefront(request.getVisibleEnStorefront() != null ? request.getVisibleEnStorefront() : Boolean.TRUE);
        producto.setDestacadoStorefront(request.getDestacadoStorefront() != null ? request.getDestacadoStorefront() : Boolean.FALSE);
        producto.setUrlImagenPrincipal(request.getUrlImagenPrincipal());
        producto.setImagenesGaleria(this.cloneList(request.getImagenesGaleria()));
        producto.setAtributos(this.cloneMap(request.getAtributos()));
        if (request.getActivo() != null) {
            producto.setActivo(request.getActivo());
        }
        Producto actualizado = (Producto)this.productoRepository.save((Object)producto);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long productoId) {
        Producto producto = (Producto)this.productoRepository.findByIdAndTiendaId(productoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Producto no encontrado"));
        this.productoRepository.delete((Object)producto);
    }

    private void validarDuplicadosAlCrear(Long tiendaId, String sku, String slug) {
        if (this.productoRepository.existsByTiendaIdAndSkuIgnoreCase(tiendaId, sku)) {
            throw new BadRequestException("El SKU ya est\u00e1 registrado para esta tienda");
        }
        if (this.productoRepository.existsByTiendaIdAndSlugIgnoreCase(tiendaId, slug)) {
            throw new BadRequestException("El slug ya est\u00e1 registrado para esta tienda");
        }
    }

    private Long resolverCategoriaId(Long tiendaId, Long categoriaId) {
        if (categoriaId == null) {
            return null;
        }
        return ((Categoria)this.categoriaRepository.findByIdAndTiendaId(categoriaId, tiendaId).orElseThrow(() -> new BadRequestException("La categor\u00eda indicada no pertenece a la tienda"))).getId();
    }

    private void validarCategoriaPerteneceATienda(Long tiendaId, Long categoriaId) {
        this.categoriaRepository.findByIdAndTiendaId(categoriaId, tiendaId).orElseThrow(() -> new BadRequestException("La categor\u00eda indicada no pertenece a la tienda"));
    }

    private List<String> cloneList(List<String> source) {
        return source == null ? new ArrayList<String>() : new ArrayList<String>(source);
    }

    private Map<String, Object> cloneMap(Map<String, Object> source) {
        return source == null ? new HashMap<String, Object>() : new HashMap<String, Object>(source);
    }

    private ProductoResponse toResponse(Producto producto) {
        String categoriaNombre = null;
        if (producto.getCategoriaId() != null) {
            categoriaNombre = this.categoriaRepository.findById((Object)producto.getCategoriaId()).map(c -> c.getNombre()).orElse(null);
        }
        return ProductoResponse.builder().id(producto.getId()).tiendaId(producto.getTiendaId()).categoriaId(producto.getCategoriaId()).categoriaNombre(categoriaNombre).nombre(producto.getNombre()).slug(producto.getSlug()).sku(producto.getSku()).descripcion(producto.getDescripcion()).tipo(producto.getTipo()).esPersonalizable(producto.getEsPersonalizable()).precioBaseCentimos(producto.getPrecioBaseCentimos()).precioOfertaCentimos(producto.getPrecioOfertaCentimos()).visibleEnPos(producto.getVisibleEnPos()).visibleEnStorefront(producto.getVisibleEnStorefront()).destacadoStorefront(producto.getDestacadoStorefront()).urlImagenPrincipal(producto.getUrlImagenPrincipal()).imagenesGaleria(this.cloneList(producto.getImagenesGaleria())).atributos(this.cloneMap(producto.getAtributos())).activo(producto.getActivo()).creadoEn(producto.getCreadoEn()).actualizadoEn(producto.getActualizadoEn()).build();
    }

    @Generated
    public ProductoAdminService(ProductoRepository productoRepository, CategoriaRepository categoriaRepository, SedeRepository sedeRepository, InventarioProductoRepository inventarioProductoRepository) {
        this.productoRepository = productoRepository;
        this.categoriaRepository = categoriaRepository;
        this.sedeRepository = sedeRepository;
        this.inventarioProductoRepository = inventarioProductoRepository;
    }
}

